/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.assertions;

import com.google.gwt.user.client.ui.ListBox;
import com.googlecode.gwt.test.assertions.BaseFocusWidgetAssert;
import com.googlecode.gwt.test.utils.WidgetUtils;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseListBoxAssert<S extends BaseListBoxAssert<S, A>, A extends ListBox>
extends BaseFocusWidgetAssert<S, A> {
    protected BaseListBoxAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S dataMatches(String ... expected) {
        int contentSize = expected.length;
        if (contentSize != ((ListBox)this.actual).getItemCount()) {
            throw this.failWithMessage("does not match actual listbox's content: [%s]", WidgetUtils.getListBoxContentToString((ListBox)this.actual));
        }
        for (int i = 0; i < contentSize; ++i) {
            if (expected[i].equals(((ListBox)this.actual).getItemText(i))) continue;
            throw this.failWithMessage("does not match actual listbox's content: [%s]", WidgetUtils.getListBoxContentToString((ListBox)this.actual));
        }
        return (S)((Object)((BaseListBoxAssert)this.myself));
    }

    public S selectedValueEquals(String expected) {
        int selectedIndex = ((ListBox)this.actual).getSelectedIndex();
        if (selectedIndex == -1) {
            throw this.failWithMessage("listbox does not have a selected value", new Object[0]);
        }
        String selected = ((ListBox)this.actual).getItemText(selectedIndex);
        if (Objects.areEqual((Object)selected, (Object)expected)) {
            return (S)((Object)((BaseListBoxAssert)this.myself));
        }
        throw this.propertyComparisonFailed("selected value", selected, expected);
    }
}

