/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test;

import com.google.gwt.user.client.rpc.RemoteService;
import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.GwtTest;
import com.googlecode.gwt.test.Mock;
import com.googlecode.gwt.test.internal.handlers.GwtTestGWTBridge;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GwtTestWithMocks
extends GwtTest {
    protected List<Class<?>> mockedClasses = new ArrayList();
    protected Set<Field> mockFields;
    protected Map<Class<?>, Object> mockObjects = new HashMap();

    public GwtTestWithMocks() {
        GwtTestGWTBridge.get().setMockCreateHandler(new MockCreateHandler(this.mockObjects));
        this.mockFields = this.getMockFields();
        for (Field f : this.mockFields) {
            this.mockedClasses.add(f.getType());
        }
    }

    @After
    public void teardownGwtTestWithMocks() {
        this.mockObjects.clear();
    }

    protected Object addMockedObject(Class<?> createClass, Object mock) {
        return this.mockObjects.put(createClass, mock);
    }

    protected Set<Field> getMockFields() {
        HashSet<Field> set = new HashSet<Field>();
        set.addAll(GwtReflectionUtils.getAnnotatedField(this.getClass(), Mock.class).keySet());
        return set;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockCreateHandler
    implements GwtCreateHandler {
        private final Map<Class<?>, Object> mockObjects;

        public MockCreateHandler(Map<Class<?>, Object> mockObjects) {
            this.mockObjects = mockObjects;
        }

        @Override
        public Object create(Class<?> classLiteral) throws Exception {
            if (RemoteService.class.isAssignableFrom(classLiteral)) {
                String asyncName = classLiteral.getName() + "Async";
                classLiteral = GwtReflectionUtils.getClass(asyncName);
            }
            return this.mockObjects.get(classLiteral);
        }
    }
}

