/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.sink;

import de.xam.texthtml.text.TextTool;
import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenSink;
import java.util.Stack;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DebugTokenSink
implements ITokenSink {
    private static final Logger log = LoggerFactory.getLogger(DebugTokenSink.class);
    private final Stack<IToken> stack = new Stack();
    private Object parseContext;

    @Override
    public String[] consumedTokenTypes() {
        return new String[0];
    }

    @Override
    public String getLabel() {
        return "sink";
    }

    @Override
    public void onAfterDocument() {
        log.info("## AFTER DOCUMENT");
    }

    @Override
    public void onBeforeDocument() {
        log.info("## BEFORE DOCUMENT");
    }

    @Override
    public void onException(Throwable e) {
        log.info("## Exception", e);
    }

    @Override
    public void onToken(IToken token) {
        if (token.isStart()) {
            this.stack.push(token);
        }
        log.info(TextTool.indent((int)this.stack.size(), (String)"  ") + (token.getKind() == IToken.Kind.Content ? "  " : "") + "##  " + token.toString(200, false));
        if (token.getKind() == IToken.Kind.End) {
            assert (!this.stack.isEmpty()) : "Closing token '" + token.getType() + "' never started. Token=" + token.toString(100, false);
            IToken open = null;
            open = this.stack.pop();
            assert (open.getType().equals(token.getType())) : "Ending token doesn't match last start token.\nStart: " + open.toString(100, false) + "\nEnd:   " + token.toString(100, false);
        }
    }

    @Override
    public String[] producedTokenTypes() {
        return new String[0];
    }

    @Override
    public void setParseContext(Object parseContext) {
        this.parseContext = parseContext;
    }
}

