/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.pipe.buffer;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.Pipes;
import de.xam.tokenpipe.Token;
import de.xam.tokenpipe.pipe.buffer.TokenBuffer;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class LookBackBuffer {
    private static final Logger log = LoggerFactory.getLogger(LookBackBuffer.class);
    private StringBuilder currentToken = new StringBuilder();
    private final String debugName;
    private final StringBuilder lookBack = new StringBuilder();
    private final TokenBuffer tokenBuffer;

    public LookBackBuffer(String debugName) {
        this.debugName = debugName;
        this.tokenBuffer = new TokenBuffer(debugName);
    }

    public LookBackBuffer(String debugName, TokenBuffer tokenBuffer) {
        assert (tokenBuffer != null);
        this.debugName = debugName;
        this.tokenBuffer = tokenBuffer;
    }

    public void clearBuffers() {
        this.currentToken.setLength(0);
        this.lookBack.setLength(0);
    }

    public void continueCurrentToken(int c) {
        this.currentToken.appendCodePoint(c);
    }

    public void continueCurrentToken(String s) {
        this.currentToken.append(s);
    }

    public int currentTokenLength() {
        return this.currentToken.length();
    }

    @SafeVarargs
    public final void fireCurrentContentToBuffer(String contentTokenType, Pair<String, String> ... attributes) {
        if (this.currentToken.length() == 0) {
            return;
        }
        Token token = Token.create(IToken.Kind.Content, contentTokenType, this.currentToken.toString(), Pipes.attributes(this.debugName, attributes));
        this.tokenBuffer.fireToken(token);
        this.currentToken.setLength(0);
    }

    @SafeVarargs
    public final void fireLookBackAsEndToBuffer(String endTokenType, Pair<String, String> ... attributes) {
        Token t = Token.create(IToken.Kind.End, endTokenType, this.lookBack.toString(), Pipes.attributes(this.debugName, attributes));
        this.tokenBuffer.fireToken(t);
        this.lookBack.setLength(0);
    }

    @SafeVarargs
    public final void fireLookBackAsStartToBuffer(String startTokenType, Pair<String, String> ... attributes) {
        Token t = Token.create(IToken.Kind.Start, startTokenType, this.lookBack.toString(), Pipes.attributes(this.debugName, attributes));
        this.tokenBuffer.fireToken(t);
        this.lookBack.setLength(0);
    }

    @SafeVarargs
    public final void fireToBuffer(IToken.Kind eventKind, String tokenType, Pair<String, String> ... attributes) {
        switch (eventKind) {
            case Start: {
                this.fireLookBackAsStartToBuffer(tokenType, attributes);
                break;
            }
            case Content: {
                this.fireCurrentContentToBuffer(tokenType, attributes);
                break;
            }
            case End: {
                this.fireLookBackAsEndToBuffer(tokenType, attributes);
            }
        }
    }

    public void flushLookback() {
        this.currentToken.append((CharSequence)this.lookBack);
        this.lookBack.setLength(0);
    }

    public void flushTokenBufferAndFireTokens(ITokenStream stream) {
        this.tokenBuffer.flushTokenBufferAndFireTokens(stream);
    }

    public void giveUpTokensAndTreatAsContent() {
        StringBuilder buf = this.tokenBuffer.flattenToStringBuilder();
        String content = this.currentToken.toString();
        this.currentToken = buf;
        this.currentToken.append(content);
    }

    public void lookBack(int codepoint) {
        this.lookBack.appendCodePoint(codepoint);
    }

    public void lookBack(String s) {
        this.lookBack.append(s);
    }

    public int lookBackLenght() {
        return this.lookBack.length();
    }

    public boolean lookBackMatches(String s) {
        return this.lookBack.toString().equals(s);
    }

    public boolean lookBackMatchesRegex(String regex) {
        return this.lookBack.toString().matches(regex);
    }

    public String toString() {
        return "debugName=" + this.debugName + "\n" + "lookBack='" + this.lookBack + "'\n" + "currentToken='" + this.currentToken + "'\n" + "tokenBuffer=" + this.tokenBuffer;
    }
}

