/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.util;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.io.common.KgifRepairJob;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.gen.Label;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.write.KgifWrites;
import java.io.IOException;
import java.util.Set;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KgifRepairs {
    private static final Logger log = LoggerFactory.getLogger(KgifRepairs.class);

    public static void addMissingNodes(IIoContext ioContext, KgifRepairJob job, Set<String> missingNodeIdStrings, IEntityHandler eh) throws IOException {
        assert (missingNodeIdStrings != null);
        if (missingNodeIdStrings.isEmpty()) {
            return;
        }
        log.info("Found nodeIds used in links but not defined as entities. Auto-creating them for " + missingNodeIdStrings);
        for (String nodeIdString : missingNodeIdStrings) {
            Node stubNode = new Node();
            stubNode.setId(nodeIdString);
            if (job.isCreateMissingNodeLabels()) {
                Label label = new Label();
                label.setContentType("http://www.w3.org/2001/XMLSchema#string");
                label.setContent(nodeIdString);
                stubNode.setLabel(label);
            }
            Metadata metadata = KgifWrites.createMetadata((String)"comment", (String)"repair: added node used in links but not declared");
            stubNode.setMetadata(metadata);
            if (ioContext.getProcessProgressReporter() != null) {
                ioContext.getProcessProgressReporter().reportProgress("Auto-creating node '" + nodeIdString + "'");
            }
            eh.onNode(ioContext, stubNode);
        }
    }

    public static String repairContentType(String contentType) {
        if (contentType.equals("vocabulary-item-dummy")) {
            return "http://www.w3.org/2001/XMLSchema#string";
        }
        return contentType;
    }
}

