/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.impl;

import com.calpano.kgif.io.common.IRepeatableStreamSource;
import com.calpano.kgif.io.common.impl.AbstractStreamSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileStreamSource
extends AbstractStreamSource
implements IRepeatableStreamSource {
    private final File file;

    public FileStreamSource(File file) {
        assert (file.getParentFile().exists()) : "directory of " + file.getAbsolutePath() + " not found";
        assert (file.getParentFile().isDirectory());
        assert (file.exists()) : "file not found " + file.getAbsolutePath();
        this.file = file;
    }

    @Override
    public String getSourceName() {
        if (this.sourceName != null) {
            return this.sourceName;
        }
        return this.file.getName();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        try {
            FileInputStream fis = new FileInputStream(this.file);
            return fis;
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getLastModificationDateUTC() {
        return this.file.lastModified();
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }
}

