/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.impl;

import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.impl.AbstractSink;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class FileStreamSink
extends AbstractSink
implements IStreamSink {
    private static final Logger log = LoggerFactory.getLogger(FileStreamSink.class);
    private final File f;

    public FileStreamSink(File f) {
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        assert (f.getParentFile().isDirectory());
        this.f = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                log.trace("IO", (Throwable)e);
            }
            finally {
                this.writer = null;
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                log.trace("IO", (Throwable)e);
            }
            finally {
                this.out = null;
            }
        }
    }

    @Override
    public String getSinkName() {
        return this.f.getAbsolutePath();
    }

    @Override
    public OutputStream openOutputStream() throws IOException, IllegalStateException {
        if (this.out != null) {
            throw new IllegalStateException("OutputStream was already open");
        }
        try {
            this.out = new FileOutputStream(this.f);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
        return this.out;
    }

    @Override
    public long getLastModificationDateUTC() {
        return this.f.lastModified();
    }
}

