/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.gae.mail;

import com.calpano.common.server.gae.mail.GaeMailUtils;
import com.calpano.common.shared.mail.IMailUser;
import com.calpano.common.shared.mail.Mail;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.time.TimeProvider;
import de.xam.velocity.AbstractVelocitySupport;
import de.xam.velocity.DataFromTemplate;
import de.xam.velocity.IVelocitySupport;
import de.xam.velocity.VelocityManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class TemplateMailService {
    private static final Logger log = LoggerFactory.getLogger(TemplateMailService.class);
    private static final String START_CONTENTPART = "----";
    private static final String START_TEXTHTML = "----text/html";
    private static final String START_TEXTPLAIN = "----text/plain";
    private static VelocityManager velocityManager;

    public static Mail computeMail(IMailUser toUser, IVelocitySupport velocitySupport, String packageName, String mailTemplateName) {
        assert (mailTemplateName != null);
        Personalisation p13n = toUser.getPersonalisation();
        return TemplateMailService.computeMail(toUser.getEmail(), toUser.getId(), toUser.getName(), p13n, toUser.getId().toString(), velocitySupport, packageName, mailTemplateName);
    }

    public static Mail computeMail(String toUserEmail, XId toUserId, String toUserName, Personalisation p13n, String userId, IVelocitySupport velocitySupport, String packageName, String mailTemplateName) {
        TemplateMailService.lazyInitVelocityManager();
        log.debug("Compute email from template '" + mailTemplateName + "' for p13n " + p13n);
        try {
            Template template = TemplateMailService.resolveTemplate(packageName, mailTemplateName, p13n);
            if (template == null) {
                throw new IllegalStateException("Found no mail template with package '" + packageName + "' name='" + mailTemplateName + "'");
            }
            return TemplateMailService.computeMail(toUserEmail, toUserId, toUserName, userId, velocitySupport, template);
        }
        catch (ResourceNotFoundException e) {
            throw new RuntimeException("Mail template '" + mailTemplateName + "' not found", e);
        }
    }

    public static Mail computeMail(String toUserEmail, XId toUserId, String toUserName, String userId, IVelocitySupport velocitySupport, Template template) {
        log.debug("Using template " + template.getName());
        assert (toUserEmail != null) : "user '" + userId + "' has no email address?";
        StringWriter sw = new StringWriter();
        try {
            Map map = velocityManager.writeResponse(velocitySupport, template, (Writer)sw);
            Mail mail = new Mail();
            String mailtexts = sw.getBuffer().toString();
            TemplateMailService.setMailtexts(mail, mailtexts);
            DataFromTemplate templ = (DataFromTemplate)map.get("templ");
            mail.subject = templ.get("subject");
            if (mail.subject == null) {
                throw new IllegalArgumentException("templ.subject not defined in velocitySupport, template: " + template.getName());
            }
            mail.recipientMailAddress = toUserEmail;
            mail.recipientName = toUserName;
            mail.recipientUserId = toUserId;
            mail.senderName = templ.get("sendername");
            if (mail.senderName == null) {
                throw new IllegalArgumentException("templ.sendername not defined in velocitySupport");
            }
            mail.senderMailAddress = templ.get("sendermail");
            if (mail.senderMailAddress == null) {
                throw new IllegalArgumentException("templ.sendermail not defined in velocitySupport");
            }
            mail.bccMailAddress = templ.get("bcc");
            mail.generatedByTemplate = template.getName();
            mail.debugMsg = "Template=" + template.getName() + " Context:" + velocitySupport.getClass().getCanonicalName();
            return mail;
        }
        catch (ParseErrorException e) {
            throw new RuntimeException("Mail template '" + template.getName() + "' parse error", e);
        }
        catch (MethodInvocationException e) {
            throw new RuntimeException("Mail template '" + template.getName() + "' caused... ", e);
        }
    }

    private static void lazyInitVelocityManager() {
        if (velocityManager == null) {
            velocityManager = new VelocityManager();
        }
    }

    public static void main(String[] args) {
        final HashMap<String, String> data = new HashMap<String, String>();
        data.put("fullName", "John Doe");
        Mail mail = TemplateMailService.computeMail("dev@xam.de", Base.toId((String)"_testUser"), "Homer Simpson", Personalisation.GERMANY, "user-id", (IVelocitySupport)new AbstractVelocitySupport(Personalisation.EN_US__SAN_FRANCISCO){

            public Object getDataForContext() {
                return data;
            }

            public String[] getMessagePackages() {
                return null;
            }
        }, "com.calpano.common.mail", "Welcome");
        System.out.println(mail.toPlainText());
    }

    public static Template resolveTemplate(String packageName, String mailTemplateName, Personalisation p13n) {
        TemplateMailService.lazyInitVelocityManager();
        String templatePath = VelocityManager.resolveTemplatePath((String)packageName, (String)mailTemplateName, (String)"vm", (Personalisation)p13n);
        if (templatePath == null) {
            return null;
        }
        return velocityManager.resolveTemplate(templatePath);
    }

    public static void sendEmailToUser(Mail mail, IMailUser user) {
        GaeMailUtils.instance().sendMail(mail, true, true);
        long now = TimeProvider.getCurrentTimeInMillis();
        user.setLastMailSent(now);
        if (user.getFirstMailSent() == 0L) {
            user.setFirstMailSent(now);
        }
    }

    private static void setMailtexts(Mail mail, String mailtexts) {
        StringReader sr = new StringReader(mailtexts);
        BufferedReader br = new BufferedReader(sr, 20000);
        StringBuffer textPlain = new StringBuffer(5000);
        StringBuffer textHtml = new StringBuffer(15000);
        ParseMode parseMode = ParseMode.None;
        try {
            String line = br.readLine();
            boolean parseLine = true;
            while (line != null) {
                if (line.contains(START_CONTENTPART)) {
                    if (line.endsWith(START_TEXTPLAIN)) {
                        parseMode = ParseMode.TextPlain;
                        parseLine = false;
                    }
                    if (line.endsWith(START_TEXTHTML)) {
                        parseMode = ParseMode.TextHtml;
                        parseLine = false;
                    }
                }
                if (parseLine) {
                    switch (parseMode) {
                        case None: {
                            log.trace("Mail debug info: '" + line + "'");
                            break;
                        }
                        case TextPlain: {
                            textPlain.append(line).append("\n");
                            break;
                        }
                        case TextHtml: {
                            textHtml.append(line).append("\n");
                        }
                    }
                }
                line = br.readLine();
                parseLine = true;
            }
            mail.messageTextPlain = textPlain.length() > 0 ? textPlain.toString() : null;
            String string = mail.messageTextHtml = textHtml.length() > 0 ? textHtml.toString() : null;
            assert (mail.messageTextHtml != null || mail.messageTextPlain != null);
        }
        catch (IOException e) {
            throw new RuntimeException("IO error when reading from strings! " + e);
        }
    }

    private static enum ParseMode {
        None,
        TextPlain,
        TextHtml;

    }
}

