/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.gae.mail;

import com.calpano.common.server.gae.mail.GaeMailUtils;
import com.calpano.common.shared.mail.Mail;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class MailSenderServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(MailSenderServlet.class);
    private static final long serialVersionUID = -3448100095736660493L;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.info("Handle send-mail-task from task queue");
        ServletInputStream in = req.getInputStream();
        ObjectInputStream ois = new ObjectInputStream((InputStream)in);
        try {
            Mail mail = (Mail)ois.readObject();
            try {
                GaeMailUtils.instance().sendEmailViaJavaMail(mail);
            }
            catch (Exception e) {
                String msg = "Error for sending mail from " + mail.senderMailAddress + " to " + mail.recipientMailAddress;
                GaeMailUtils.instance().createMailToAdmins("mail", msg);
                log.warn(msg, (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }
}

