/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.gae.mail;

import com.calpano.common.server.gae.mail.ServerMailUtils;
import com.calpano.common.server.services.crashreport.ISendErrorMailService;
import com.calpano.common.server.util.ExceptionUtils;
import com.calpano.common.shared.mail.Mail;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.apphosting.api.ApiProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.xydra.base.XId;
import org.xydra.core.XX;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.xgae.gaeutils.AboutAppEngine;
import org.xydra.xgae.gaeutils.GaeConstants;

public class GaeMailUtils
extends ServerMailUtils
implements ISendErrorMailService {
    private static Logger log = LoggerFactory.getLogger(GaeMailUtils.class);
    private static GaeMailUtils INSTANCE;
    public static final String MAIL_QUEUE_NAME = "mail";
    public static final XId ACTOR_MAILSYSTEM;

    public static synchronized GaeMailUtils instance() {
        if (INSTANCE == null) {
            INSTANCE = new GaeMailUtils();
        }
        return INSTANCE;
    }

    public Mail createMailToAdmins(String tag, String subject) {
        String appEngineId = AboutAppEngine.getApplicationId();
        Mail mail = new Mail();
        mail.recipientMailAddress = "team@calpano.com";
        mail.recipientName = "Favr Ops";
        mail.senderMailAddress = "admin@calpano.com";
        mail.senderName = "Admin " + appEngineId;
        mail.subject = "[" + tag + "] " + subject;
        return mail;
    }

    public void putMailInTaskQueue(Mail mail) {
        Queue queue = QueueFactory.getQueue((String)MAIL_QUEUE_NAME);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(mail);
            oos.flush();
            oos.close();
            byte[] bytes = baos.toByteArray();
            baos.close();
            if ((long)bytes.length >= GaeConstants.MAX_GAE_TASk_PAYLOAD_SIZE) {
                log.warn("Enqueuing mail with " + bytes.length + " bytes. This would not work so we send it now GA?category=warn&action=sendLargeMail");
                this.sendEmailViaJavaMail(mail);
            } else {
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/admin/sendmail").payload(bytes, "x-objectstream");
                queue.add(options);
            }
        }
        catch (IOException e) {
            log.error("Could not enqueue", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void sendEmailViaJavaMail(Mail mail) throws UnsupportedEncodingException {
        log.info("Sending mail via SMTP to " + mail.recipientMailAddress);
        if (!mail.hasMinimalData()) {
            log.error("Email to " + mail.recipientMailAddress + " is not complete, did not send");
            throw new IllegalArgumentException("Mail is not complete");
        }
        Properties props = new Properties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)GaeMailUtils.toInternetAddress(mail.senderMailAddress, mail.senderName));
            msg.addRecipient(Message.RecipientType.TO, (Address)GaeMailUtils.toInternetAddress(mail.recipientMailAddress, mail.recipientName));
            if (mail.bccMailAddress != null) {
                msg.addRecipient(Message.RecipientType.BCC, (Address)GaeMailUtils.toInternetAddress(mail.bccMailAddress, null));
            }
            msg.setSubject(mail.subject, "utf-8");
            if (mail.hasHybridBody()) {
                MimeMultipart mp = new MimeMultipart();
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setText(mail.messageTextPlain, "utf-8", "plain");
                textPart.setDisposition("inline");
                mp.addBodyPart((BodyPart)textPart);
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent((Object)mail.messageTextHtml, "text/html; charset=utf-8");
                htmlPart.addHeader("Content-Type", "text/html; charset=utf-8");
                if (!htmlPart.getContentType().equals("text/html; charset=utf-8")) {
                    log.warn("Content-Type of htmlPart changed to '" + htmlPart.getContentType() + "'");
                }
                mp.addBodyPart((BodyPart)htmlPart);
                msg.setContent((Multipart)mp);
            } else if (mail.hasTextHtmlBody()) {
                msg.setText(mail.messageTextHtml, "utf-8", "html");
            } else {
                assert (mail.hasTextPlainBody());
                msg.setText(mail.messageTextPlain, "utf-8", "plain");
            }
            msg.saveChanges();
            try {
                Transport.send((Message)msg);
            }
            catch (ApiProxy.CallNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (ApiProxy.OverQuotaException e) {
                log.error("Email quota problem GA?category=error&action=mailOverQuota", (Throwable)e);
                Mail adminMail = this.createMailToAdmins("Danger", "Mail quota empty");
                mail.messageTextHtml = ExceptionUtils.toHtmlStringWithStacktrace((Throwable)e);
                this.sendEmailViaJavaMail(adminMail);
            }
            catch (SendFailedException e) {
                log.warn("Failed to send email from " + mail.senderMailAddress + " to " + mail.recipientMailAddress, (Throwable)e);
            }
            catch (MessagingException e) {
                log.error("Weird error when sending mail", (Throwable)e);
            }
        }
        catch (AddressException e) {
            log.error("AddressException", (Throwable)e);
            throw new RuntimeException("For mail from " + mail.senderMailAddress + " to " + mail.recipientMailAddress, e);
        }
        catch (MessagingException e) {
            log.error("MessagingException", (Throwable)e);
            throw new RuntimeException("For mail from " + mail.senderMailAddress + " to " + mail.recipientMailAddress, e);
        }
    }

    public void sendMail(Mail mail, boolean viaTaskQueue, boolean userMail) {
        assert (!userMail || !mail.containsDollarOpenCurlyBrace());
        log.info("Sending mail to " + mail.recipientMailAddress + ": " + mail.subject);
        if (AboutAppEngine.inProduction()) {
            mail.debugMsg = null;
            this.sendMailOnGae(mail, viaTaskQueue);
        } else {
            GaeMailUtils.simulateSendEmail(mail);
        }
    }

    private void sendMailOnGae(Mail mail, boolean viaTaskQueue) {
        if (viaTaskQueue) {
            this.putMailInTaskQueue(mail);
        } else {
            try {
                this.sendEmailViaJavaMail(mail);
            }
            catch (UnsupportedEncodingException e) {
                log.error("Error sending mail", (Throwable)e);
            }
        }
    }

    static {
        ACTOR_MAILSYSTEM = XX.toId((String)"_mailSystem");
    }
}

