/*
 * Decompiled with CFR 0.152.
 */
package de.xam.datafiles.handler;

import de.xam.datafiles.handler.IDataFileHandler;
import de.xam.datafiles.store.CsvStore;
import de.xam.datafiles.store.DataMapStoreTools;
import de.xam.datafiles.store.IDataMapStore;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.xydra.csv.impl.memory.CsvTable;

public class CsvHandler
implements IDataFileHandler {
    private final String columnName;

    public CsvHandler(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public IDataMapStore read(File f) throws IOException {
        CsvTable table = new CsvTable();
        table.readFrom(f);
        return new CsvStore(this.columnName);
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(CsvHandler.this.getExtension());
            }
        };
    }

    @Override
    public void write(IDataMapStore dataMap, File f) throws IOException {
        CsvStore csvStore = new CsvStore(this.columnName);
        DataMapStoreTools.copy(dataMap, csvStore);
        csvStore.getTable().writeTo(f);
    }

    @Override
    public String getEncoding() {
        return "utf-8";
    }

    @Override
    public String getExtension() {
        return ".csv";
    }
}

