/*
 * Decompiled with CFR 0.152.
 */
package de.xam.velocity;

import de.xam.p13n.server.LocaleUtils;
import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.MissingMessageKeys;
import de.xam.resourceloader.ResourceClasspathScanner;
import de.xam.resourceloader.p13n.PersonalisedMessageBundleIO;
import de.xam.velocity.IVelocitySupport;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.xydra.annotations.Template;
import org.xydra.env.Env;
import org.xydra.index.impl.MapMapIndex;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.utils.SharedHtmlUtils;

public class ReflectiveContextEntry {
    private static Logger log = LoggerFactory.getLogger(ReflectiveContextEntry.class);
    public static final int MAX_STRING_LENGTH_FOR_VALUES = 80;
    private final IVelocitySupport data;

    public ReflectiveContextEntry(IVelocitySupport data) {
        this.data = data;
    }

    public String getDebug() {
        HashMap<String, Object> debugDataMap = new HashMap<String, Object>();
        debugDataMap.put("debug", this.data.getDebugDataForContext());
        debugDataMap.put("classname", this.data.getClass().getName());
        for (String missingKey : MissingMessageKeys.map().keySet()) {
            debugDataMap.put("missing msgKey '" + missingKey + "' for languages", MissingMessageKeys.get((String)missingKey));
        }
        return SharedHtmlUtils.toDefinitionList(debugDataMap);
    }

    public String getKeysData() {
        HashSet seen = new HashSet();
        seen.add(this.data.getClass());
        Object o = this.data.getDataForContext();
        assert (o != null);
        return SharedHtmlUtils.toOrderedList(this.getMethodsExposedInTemplate(o, seen));
    }

    public String getKeysMsg() {
        MapMapIndex msgKey_language_value = new MapMapIndex();
        log.info("Loading all .utf8 files...");
        List utf8FileNames = ResourceClasspathScanner.findRessources((String)".*\\.utf8");
        if (Env.get().conf().getBoolean("template-inProduction")) {
            log.warn("List of messages keys are usually incomplete on AppEngine");
        }
        for (String utf8Filename : utf8FileNames) {
            File f = new File(utf8Filename);
            if (!f.exists()) continue;
            MiniLocale locale = LocaleUtils.getLocale((File)f);
            assert (locale != null) : "Locale null for " + f.getAbsolutePath();
            String localeString = locale.toString();
            try {
                URL url = f.toURL();
                InputStream in = url.openStream();
                InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                Map map = PersonalisedMessageBundleIO.toMap((Reader)reader, (URL)url);
                for (Map.Entry e : map.entrySet()) {
                    msgKey_language_value.index(e.getKey(), (Object)localeString, e.getValue());
                }
            }
            catch (Exception e) {
                log.warn("while creating reflective context", (Throwable)e);
            }
        }
        log.debug("Transform into nested lists");
        Iterator msgKeyIt = msgKey_language_value.key1Iterator();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        while (msgKeyIt.hasNext()) {
            Iterator langIt = msgKey_language_value.key2Iterator();
            HashMap<String, String> lang2valuesMap = new HashMap<String, String>();
            String msgKey = (String)msgKeyIt.next();
            assert (msgKey != null);
            while (langIt.hasNext()) {
                String language = (String)langIt.next();
                String value = (String)msgKey_language_value.lookup((Object)msgKey, (Object)language);
                if (value == null) continue;
                lang2valuesMap.put(language, value);
            }
            String localList = SharedHtmlUtils.toDefinitionList(lang2valuesMap);
            resultMap.put(msgKey, localList);
        }
        return SharedHtmlUtils.toDefinitionList(resultMap);
    }

    private List<String> getMethodsExposedInTemplate(Object object, Set<Class<?>> seenTypes) {
        assert (object != null);
        assert (seenTypes != null);
        LinkedList<Method> methodsToInspect = new LinkedList<Method>();
        for (Method method : object.getClass().getMethods()) {
            methodsToInspect.add(method);
        }
        for (GenericDeclaration genericDeclaration : object.getClass().getInterfaces()) {
            for (Method method : ((Class)genericDeclaration).getMethods()) {
                methodsToInspect.add(method);
            }
        }
        HashSet<String> keys = new HashSet<String>();
        for (Method method : methodsToInspect) {
            String m;
            block20: {
                Template template = method.getAnnotation(Template.class);
                if (template == null) continue;
                String name = method.getName();
                m = "/* " + template.value() + " */<br />";
                if (name.startsWith("get")) {
                    String readableName = name.substring(3);
                    readableName = readableName.substring(0, 1).toLowerCase() + readableName.substring(1);
                    m = m + "<b>" + readableName + "</b> (" + method.getReturnType().getSimpleName() + ") ";
                    try {
                        Object result = method.invoke(object, new Object[0]);
                        if (result == null) {
                            m = m + "-- (empty, no information)";
                            break block20;
                        }
                        if (!seenTypes.contains(result.getClass())) {
                            seenTypes.add(result.getClass());
                            m = m + " '" + ReflectiveContextEntry.toStringWithMaxLength(result, 80) + "'";
                            log.debug("Inspecting " + result.getClass().getSimpleName());
                            if (result instanceof Iterable) {
                                Iterable iterableResult = (Iterable)result;
                                try {
                                    Iterator iterator = iterableResult.iterator();
                                    if (iterator.hasNext()) {
                                        Object collectionMember = iterator.next();
                                        if (collectionMember == null) {
                                            m = m + "collectionMember is null in collection " + result.getClass().getName();
                                        } else {
                                            seenTypes.add(collectionMember.getClass());
                                            log.info("Recurse on " + collectionMember.getClass().getSimpleName());
                                            List<String> recursiveMethods = this.getMethodsExposedInTemplate(collectionMember, seenTypes);
                                            m = m + "each: " + SharedHtmlUtils.toOrderedList(recursiveMethods);
                                        }
                                        break block20;
                                    }
                                    m = m + "empty iterator";
                                }
                                catch (NoSuchElementException e) {
                                    m = m + "each: -- (empty collection, no information)";
                                }
                                break block20;
                            }
                            List<String> recursiveMethods = this.getMethodsExposedInTemplate(result, seenTypes);
                            m = m + SharedHtmlUtils.toOrderedList(recursiveMethods);
                            break block20;
                        }
                        log.debug("Object (" + result.getClass().getName() + ") already seen - Avoiding cycle");
                    }
                    catch (IllegalArgumentException e) {
                        m = m + e.getMessage();
                    }
                    catch (IllegalAccessException e) {
                        m = m + e.getMessage();
                    }
                    catch (InvocationTargetException e) {
                        m = m + e.getMessage();
                    }
                } else {
                    m = m + name;
                }
            }
            keys.add(m);
        }
        ArrayList<String> sortedKeys = new ArrayList<String>(keys);
        Collections.sort(sortedKeys);
        return sortedKeys;
    }

    private static String toStringWithMaxLength(Object result, int maxStringLengthForValues) {
        String valueString = result.toString();
        valueString = valueString.substring(0, Math.min(maxStringLengthForValues, valueString.length()));
        return valueString;
    }
}

