/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.server.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.change.XCommand;
import org.xydra.base.minio.MiniStreamWriter;
import org.xydra.base.minio.MiniWriter;
import org.xydra.core.StoreException;
import org.xydra.core.serialize.SerializedCommand;
import org.xydra.core.serialize.XydraElement;
import org.xydra.core.serialize.XydraOut;
import org.xydra.core.serialize.XydraParser;
import org.xydra.core.serialize.json.JsonOut;
import org.xydra.core.serialize.json.JsonParser;
import org.xydra.core.serialize.xml.XmlOut;
import org.xydra.core.serialize.xml.XmlParser;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.persistence.GetEventsRequest;
import org.xydra.persistence.GetWithAddressRequest;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.Delay;
import org.xydra.server.rest.XydraRestServer;
import org.xydra.store.BatchedResult;
import org.xydra.store.Callback;
import org.xydra.store.RequestException;
import org.xydra.store.WaitingCallback;
import org.xydra.store.XydraRuntime;
import org.xydra.store.XydraStore;
import org.xydra.store.serialize.SerializedStore;

public class XydraStoreResource {
    private static final Logger log = LoggerFactory.getLogger(XydraStoreResource.class);
    private static final XydraParser jsonParser = new JsonParser();
    private static final XydraParser xmlParser = new XmlParser();
    private static final Set<String> jsonMimes = new HashSet<String>();
    private static final Set<String> xmlMimes = new HashSet<String>();
    private static final Set<String> mimes = new HashSet<String>();
    private static final Pattern callbackRegex = Pattern.compile("^[a-z0-9_]+$");

    public static void restless(Restless restless, String apiLocation) {
        log.info("Init at apiLocation=" + apiLocation);
        jsonMimes.add("application/json");
        jsonMimes.add("application/x-javascript");
        jsonMimes.add("text/javascript");
        jsonMimes.add("text/x-javascript");
        jsonMimes.add("text/x-json");
        jsonMimes.add("application/javascript");
        jsonMimes.add("text/ecmascript");
        jsonMimes.add("application/ecmascript");
        mimes.addAll(jsonMimes);
        xmlMimes.add("application/xml");
        xmlMimes.add("text/xml");
        mimes.addAll(xmlMimes);
        String prefix = apiLocation + "/";
        RestlessParameter actorId = new RestlessParameter("actorId");
        RestlessParameter passwordHash = new RestlessParameter("passwordHash");
        restless.addMethod(prefix + "login", "GET", XydraStoreResource.class, "checkLogin", false, new RestlessParameter[]{actorId, passwordHash});
        RestlessParameter addresses = new RestlessParameter("address", true);
        RestlessParameter from = new RestlessParameter("beginRevision", true);
        RestlessParameter to = new RestlessParameter("endRevision", true);
        restless.addMethod(prefix + "execute", "POST", XydraStoreResource.class, "executeCommands", false, new RestlessParameter[]{actorId, passwordHash, addresses, from, to});
        restless.addMethod(prefix + "events", "GET", XydraStoreResource.class, "getEvents", false, new RestlessParameter[]{actorId, passwordHash, addresses, from, to});
        restless.addMethod(prefix + "revisions", "GET", XydraStoreResource.class, "getModelRevisions", false, new RestlessParameter[]{actorId, passwordHash, addresses});
        restless.addMethod(prefix + "snapshots", "GET", XydraStoreResource.class, "getSnapshots", false, new RestlessParameter[]{actorId, passwordHash, addresses});
        restless.addMethod(prefix + "repository/models", "GET", XydraStoreResource.class, "getModelIds", false, new RestlessParameter[]{actorId, passwordHash});
        restless.addMethod(prefix + "repository/id", "GET", XydraStoreResource.class, "getRepositoryId", false, new RestlessParameter[]{actorId, passwordHash});
        restless.addMethod(prefix + "ping", "GET", XydraStoreResource.class, "ping", false, new RestlessParameter[0]);
        log.info("Exposing ping service at " + prefix + "ping");
    }

    public boolean onException(Throwable t, IRestlessContext context) {
        XydraRuntime.finishRequest();
        if (t instanceof InitException) {
            try {
                context.getResponse().sendError(400, t.getMessage());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        if (!(t instanceof StoreException) && !(t instanceof IllegalArgumentException)) {
            return false;
        }
        XydraOut out = XydraStoreResource.startOutput(context, 200);
        SerializedStore.serializeException((Throwable)t, (XydraOut)out);
        out.flush();
        return true;
    }

    private static XId getActorId(String actorIdString) {
        try {
            return Base.toId((String)actorIdString);
        }
        catch (Throwable t) {
            throw new RequestException("invalid actor XId: " + actorIdString);
        }
    }

    private static String getBestContentType(IRestlessContext context, Set<String> choices, String def) {
        HttpServletRequest req = context.getRequest();
        String mime = req.getParameter("accept");
        if (mime != null) {
            if (!choices.contains(mime = mime.trim().toLowerCase())) {
                throw new InitException("Unexpected content type: " + mime);
            }
            return mime;
        }
        String best = def;
        float bestScore = Float.MIN_VALUE;
        Enumeration headers = req.getHeaders("Accept");
        while (headers.hasMoreElements()) {
            String[] types;
            String accept = ((String)headers.nextElement()).toLowerCase();
            for (String type : types = accept.split(",")) {
                String[] param;
                String[] parts = type.split(";");
                if (!choices.contains(parts[0])) continue;
                float score = 1.0f;
                if (parts.length > 1 && (param = parts[1].split("=")).length > 1 && param[0].trim() == "q") {
                    score = Float.parseFloat(param[1].trim());
                }
                if (!(score > bestScore)) continue;
                best = parts[0];
                bestScore = score;
            }
        }
        return best;
    }

    private static XydraOut startOutput(IRestlessContext context, int statusCode) {
        String mime;
        HttpServletResponse res = context.getResponse();
        String callback = context.getRequest().getParameter("callback");
        if (callback != null) {
            if (!callbackRegex.matcher(callback).matches()) {
                throw new InitException("Invalid callback: " + callback);
            }
            mime = XydraStoreResource.getBestContentType(context, jsonMimes, "text/javascript");
        } else {
            mime = XydraStoreResource.getBestContentType(context, mimes, "application/xml");
        }
        res.setStatus(statusCode);
        res.setContentType(mime + "; charset=UTF-8");
        res.setCharacterEncoding("utf-8");
        try {
            XmlOut out;
            MiniStreamWriter writer = new MiniStreamWriter((OutputStream)res.getOutputStream());
            if (xmlMimes.contains(mime)) {
                out = new XmlOut((MiniWriter)writer);
            } else if (jsonMimes.contains(mime)) {
                out = callback != null ? new JsonOut((MiniWriter)writer, callback) : new JsonOut((MiniWriter)writer);
            } else {
                throw new AssertionError();
            }
            String format = context.getRequest().getParameter("format");
            if ("pretty".equals(format)) {
                out.enableWhitespace(true, true);
            }
            return out;
        }
        catch (IOException e) {
            throw new RuntimeException("re-throw", e);
        }
    }

    public void checkLogin(IRestlessContext context, String actorIdStr, String passwordHash) throws Throwable {
        XydraRuntime.startRequest();
        XydraStore store = XydraRestServer.getStore(context.getRestless());
        XId actorId = XydraStoreResource.getActorId(actorIdStr);
        WaitingCallback callback = new WaitingCallback();
        store.checkLogin(actorId, passwordHash, (Callback)callback);
        if (callback.getException() != null) {
            throw callback.getException();
        }
        XydraOut out = XydraStoreResource.startOutput(context, 200);
        SerializedStore.serializeAuthenticationResult((boolean)((Boolean)callback.getResult()), (XydraOut)out);
        out.flush();
        XydraRuntime.finishRequest();
    }

    public void executeCommands(IRestlessContext context, String actorIdStr, String passwordHash, String[] addresses, String[] from, String[] to) throws Throwable {
        BatchedResult[] eventsRes;
        BatchedResult[] commandRes;
        WaitingCallback callback;
        List commandsList;
        if (Delay.isSimulateDelay()) {
            Delay.ajax();
        }
        XydraRuntime.startRequest();
        XydraStore store = XydraRestServer.getStore(context.getRestless());
        XId actorId = XydraStoreResource.getActorId(actorIdStr);
        SerializedStore.EventsRequest ger = XydraStoreResource.parseEventsRequest(addresses, from, to);
        WaitingCallback repoId = new WaitingCallback();
        store.getRepositoryId(actorId, passwordHash, (Callback)repoId);
        if (repoId.getException() != null) {
            throw repoId.getException();
        }
        XAddress repoAddr = Base.toAddress((XId)((XId)repoId.getResult()), null, null, null);
        String rawCommands = XydraRestServer.readPostData(context.getRequest());
        try {
            XydraElement element;
            String mime = context.getRequest().getContentType();
            if (mime != null && jsonMimes.contains(mime.toLowerCase())) {
                try {
                    element = jsonParser.parse(rawCommands);
                }
                catch (Exception e) {
                    element = xmlParser.parse(rawCommands);
                }
            } else {
                try {
                    element = xmlParser.parse(rawCommands);
                }
                catch (Exception e) {
                    element = jsonParser.parse(rawCommands);
                }
            }
            commandsList = SerializedCommand.toCommandList((XydraElement)element, (XAddress)repoAddr);
        }
        catch (Exception e) {
            throw new RequestException("error parsing commands list: " + e.getMessage());
        }
        XCommand[] commands = commandsList.toArray(new XCommand[commandsList.size()]);
        if (ger.requests.length == 0) {
            callback = new WaitingCallback();
            store.executeCommands(actorId, passwordHash, commands, (Callback)callback);
            if (callback.getException() != null) {
                throw callback.getException();
            }
            commandRes = (BatchedResult[])callback.getResult();
            eventsRes = null;
        } else {
            callback = new WaitingCallback();
            store.executeCommandsAndGetEvents(actorId, passwordHash, commands, ger.requests, (Callback)callback);
            if (callback.getException() != null) {
                throw callback.getException();
            }
            assert (callback.getResult() != null);
            commandRes = (BatchedResult[])((Pair)callback.getResult()).getFirst();
            eventsRes = (BatchedResult[])((Pair)callback.getResult()).getSecond();
        }
        XydraOut out = XydraStoreResource.startOutput(context, 200);
        SerializedStore.serializeCommandResults((BatchedResult[])commandRes, (SerializedStore.EventsRequest)ger, eventsRes, (XydraOut)out);
        out.flush();
        XydraRuntime.finishRequest();
    }

    private static SerializedStore.EventsRequest parseEventsRequest(String[] addresses, String[] from, String[] to) {
        if (addresses.length < from.length || addresses.length < to.length) {
            throw new RequestException("illegal parameter combination: addresses=" + Arrays.toString(addresses) + ", " + "beginRevision" + "s=" + Arrays.toString(from) + ", " + "endRevision" + "s=" + Arrays.toString(to));
        }
        StoreException[] exceptions = new StoreException[addresses.length];
        GetEventsRequest[] requests = new GetEventsRequest[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            XAddress address;
            try {
                address = Base.toAddress((String)addresses[i]);
            }
            catch (Exception e) {
                exceptions[i] = new RequestException("invalid address: " + addresses[i]);
                continue;
            }
            long begin = 0L;
            long end = Long.MAX_VALUE;
            if (i < from.length && !from[i].isEmpty()) {
                try {
                    begin = Long.parseLong(from[i]);
                }
                catch (Exception e) {
                    exceptions[i] = new RequestException("invalid beginRevision: " + from[i]);
                    continue;
                }
            }
            if (i < to.length && !to[i].isEmpty()) {
                try {
                    end = Long.parseLong(to[i]);
                }
                catch (Exception e) {
                    exceptions[i] = new RequestException("invalid endRevision: " + to[i]);
                    continue;
                }
            }
            requests[i] = new GetEventsRequest(address, begin, end);
        }
        return new SerializedStore.EventsRequest(exceptions, requests);
    }

    public void getEvents(IRestlessContext context, String actorIdStr, String passwordHash, String[] addresses, String[] from, String[] to) throws Throwable {
        if (Delay.isSimulateDelay()) {
            Delay.ajax();
        }
        XydraRuntime.startRequest();
        XydraStore store = XydraRestServer.getStore(context.getRestless());
        XId actorId = XydraStoreResource.getActorId(actorIdStr);
        SerializedStore.EventsRequest ger = XydraStoreResource.parseEventsRequest(addresses, from, to);
        WaitingCallback callback = new WaitingCallback();
        store.getEvents(actorId, passwordHash, ger.requests, (Callback)callback);
        if (callback.getException() != null) {
            throw callback.getException();
        }
        XydraOut out = XydraStoreResource.startOutput(context, 200);
        SerializedStore.serializeEventsResults((SerializedStore.EventsRequest)ger, (BatchedResult[])((BatchedResult[])callback.getResult()), (XydraOut)out);
        out.flush();
        XydraRuntime.finishRequest();
    }

    public void getModelRevisions(IRestlessContext context, String actorIdStr, String passwordHash, String[] addresses) throws Throwable {
        XydraRuntime.startRequest();
        XydraStore store = XydraRestServer.getStore(context.getRestless());
        XId actorId = XydraStoreResource.getActorId(actorIdStr);
        StoreException[] ex = new StoreException[addresses.length];
        GetWithAddressRequest[] modelAddressRequests = new GetWithAddressRequest[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            try {
                modelAddressRequests[i] = new GetWithAddressRequest(Base.toAddress((String)addresses[i]));
                continue;
            }
            catch (Exception e) {
                ex[i] = new RequestException("invalid address: " + addresses[i]);
            }
        }
        WaitingCallback callback = new WaitingCallback();
        store.getModelRevisions(actorId, passwordHash, modelAddressRequests, (Callback)callback);
        if (callback.getException() != null) {
            throw callback.getException();
        }
        XydraOut out = XydraStoreResource.startOutput(context, 200);
        SerializedStore.serializeModelRevisions((BatchedResult[])((BatchedResult[])callback.getResult()), (XydraOut)out);
        out.flush();
        XydraRuntime.finishRequest();
    }

    public void getSnapshots(IRestlessContext context, String actorIdStr, String passwordHash, String[] addressStrs) throws Throwable {
        XydraRuntime.startRequest();
        XydraStore store = XydraRestServer.getStore(context.getRestless());
        XId actorId = XydraStoreResource.getActorId(actorIdStr);
        ArrayList<XAddress> modelAddrs = new ArrayList<XAddress>();
        ArrayList<XAddress> objectAddrs = new ArrayList<XAddress>();
        StoreException[] ex = new StoreException[addressStrs.length];
        boolean[] isModel = new boolean[addressStrs.length];
        for (int i = 0; i < addressStrs.length; ++i) {
            XAddress addr;
            try {
                addr = Base.toAddress((String)addressStrs[i]);
            }
            catch (Exception e) {
                ex[i] = new RequestException("invalid address: " + addressStrs[i]);
                continue;
            }
            XType type = addr.getAddressedType();
            if (type == XType.XMODEL) {
                modelAddrs.add(addr);
                isModel[i] = true;
                continue;
            }
            if (type == XType.XOBJECT) {
                objectAddrs.add(addr);
                isModel[i] = false;
                continue;
            }
            ex[i] = new RequestException("address does not refer to a model or object: " + addr);
        }
        GetWithAddressRequest[] mreq = new GetWithAddressRequest[modelAddrs.size()];
        for (int i = 0; i < mreq.length; ++i) {
            mreq[i] = new GetWithAddressRequest((XAddress)modelAddrs.get(i));
        }
        GetWithAddressRequest[] oreq = new GetWithAddressRequest[objectAddrs.size()];
        for (int i = 0; i < oreq.length; ++i) {
            oreq[i] = new GetWithAddressRequest((XAddress)objectAddrs.get(i));
        }
        WaitingCallback mc = new WaitingCallback();
        store.getModelSnapshots(actorId, passwordHash, mreq, (Callback)mc);
        if (mc.getException() != null) {
            throw mc.getException();
        }
        assert (mc.getResult() != null && ((BatchedResult[])mc.getResult()).length == mreq.length);
        WaitingCallback oc = new WaitingCallback();
        store.getObjectSnapshots(actorId, passwordHash, oreq, (Callback)oc);
        if (oc.getException() != null) {
            throw oc.getException();
        }
        assert (oc.getResult() != null && ((BatchedResult[])oc.getResult()).length == oreq.length);
        XydraOut out = XydraStoreResource.startOutput(context, 200);
        BatchedResult[] mres = (BatchedResult[])mc.getResult();
        BatchedResult[] ores = (BatchedResult[])oc.getResult();
        SerializedStore.serializeSnapshots((StoreException[])ex, (boolean[])isModel, (BatchedResult[])mres, (BatchedResult[])ores, (XydraOut)out);
        out.flush();
        XydraRuntime.finishRequest();
    }

    public void getModelIds(IRestlessContext context, String actorIdStr, String passwordHash) throws Throwable {
        XydraRuntime.startRequest();
        XydraStore store = XydraRestServer.getStore(context.getRestless());
        XId actorId = XydraStoreResource.getActorId(actorIdStr);
        WaitingCallback callback = new WaitingCallback();
        store.getModelIds(actorId, passwordHash, (Callback)callback);
        if (callback.getException() != null) {
            throw callback.getException();
        }
        XydraOut out = XydraStoreResource.startOutput(context, 200);
        SerializedStore.serializeModelIds((Set)((Set)callback.getResult()), (XydraOut)out);
        out.flush();
        XydraRuntime.finishRequest();
    }

    public void getRepositoryId(IRestlessContext context, String actorIdStr, String passwordHash) throws Throwable {
        XydraRuntime.startRequest();
        XydraStore store = XydraRestServer.getStore(context.getRestless());
        XId actorId = XydraStoreResource.getActorId(actorIdStr);
        WaitingCallback callback = new WaitingCallback();
        store.getRepositoryId(actorId, passwordHash, (Callback)callback);
        if (callback.getException() != null) {
            throw callback.getException();
        }
        XydraOut out = XydraStoreResource.startOutput(context, 200);
        SerializedStore.serializeRepositoryId((XId)((XId)callback.getResult()), (XydraOut)out);
        out.flush();
        XydraRuntime.finishRequest();
    }

    public String ping() {
        return "Hello World!";
    }

    private static class InitException
    extends RuntimeException {
        private static final long serialVersionUID = -1357932793964520833L;

        public InitException(String message) {
            super(message);
        }
    }
}

