/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.core.shared.query;

import com.sonicmetrics.core.shared.impl.memory.SonicUtils;
import java.io.Serializable;

public class TimeConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final TimeConstraint ALL_UNTIL_NOW = new TimeConstraint(0L, Long.MAX_VALUE, null);
    public final String lastKey;
    public final long start;
    public final long end;

    private TimeConstraint(long startInclusive, long endInclusive, String lastkey) {
        this.start = startInclusive;
        this.end = endInclusive;
        this.lastKey = lastkey;
    }

    public static TimeConstraint fromTo(long startInclusive, long endInclusive) {
        return new TimeConstraint(startInclusive, endInclusive, null);
    }

    public static TimeConstraint from(long startInclusive) {
        return new TimeConstraint(startInclusive, Long.MAX_VALUE, null);
    }

    public static TimeConstraint sinceLastkey(String lastKey) {
        return new TimeConstraint(0L, Long.MAX_VALUE, lastKey);
    }

    public boolean isConstraining() {
        return this.start > 0L || this.lastKey != null || this.end < Long.MAX_VALUE;
    }

    public long getIntervalLength() {
        return this.end - this.start;
    }

    public String toString() {
        return (this.lastKey == null ? "[" + this.start : "(key=" + this.lastKey) + "," + this.end + "]";
    }

    public boolean equals(Object other) {
        return other instanceof TimeConstraint && TimeConstraint.equals(this, (TimeConstraint)other);
    }

    public int hashCode() {
        return (int)(this.start + this.end + (long)SonicUtils.hashCode(this.lastKey));
    }

    public static boolean equals(TimeConstraint a, TimeConstraint b) {
        return a.start == b.start && a.end == b.end && a.lastKey == b.lastKey;
    }

    public boolean includes(TimeConstraint other) {
        boolean includesInterval;
        boolean bl = includesInterval = this.start <= other.start && this.end >= other.end;
        if (!includesInterval) {
            return false;
        }
        if (this.lastKey == null) {
            return true;
        }
        return this.lastKey.compareTo(other.lastKey) < 0;
    }
}

