/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.core.shared.query;

import com.sonicmetrics.core.shared.impl.memory.SonicUtils;
import com.sonicmetrics.core.shared.query.ISonicQuery;
import com.sonicmetrics.core.shared.query.KeyValueConstraint;
import com.sonicmetrics.core.shared.query.SonicFilter;
import com.sonicmetrics.core.shared.query.TimeConstraint;

public class SonicQuery
extends SonicFilter
implements ISonicQuery {
    private static final long serialVersionUID = 1L;
    private final TimeConstraint timeConstraint;
    private int limit;

    public SonicQuery(TimeConstraint timeConstraint, int limit, KeyValueConstraint ... keyValueConstraints) {
        super(keyValueConstraints);
        this.timeConstraint = timeConstraint;
        this.limit = limit;
    }

    public static Builder build(TimeConstraint timeConstraint) {
        return new Builder(timeConstraint);
    }

    public boolean isTimeConstrained() {
        return this.timeConstraint != null && this.timeConstraint.isConstraining();
    }

    @Override
    public TimeConstraint getTimeConstraint() {
        return this.timeConstraint;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timeConstraint.toString());
        for (KeyValueConstraint c : this.keyValueConstraints.values()) {
            sb.append(" '" + c.getKey() + "'='" + c.getValue() + "'");
        }
        sb.append(" limit:" + this.limit);
        return sb.toString();
    }

    public static boolean equals(ISonicQuery a, ISonicQuery b) {
        if (!SonicFilter.equals(a, b)) {
            return false;
        }
        if (!a.getTimeConstraint().equals(b.getTimeConstraint())) {
            return false;
        }
        return a.getLimit() == b.getLimit();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ISonicQuery)) {
            return false;
        }
        ISonicQuery o = (ISonicQuery)other;
        return SonicQuery.equals(this, o);
    }

    public boolean includes(ISonicQuery other) {
        if (!super.includes(other)) {
            return false;
        }
        if (!this.getTimeConstraint().includes(other.getTimeConstraint())) {
            return false;
        }
        return this.getLimit() >= other.getLimit();
    }

    @Override
    public int hashCode() {
        return SonicUtils.hashCode(this.getSubject()) + SonicUtils.hashCode(this.getSource()) + SonicUtils.hashCode(this.getCategory()) + SonicUtils.hashCode(this.getAction()) + SonicUtils.hashCode(this.getLabel());
    }

    public static class Builder
    extends SonicFilter.AbstractBuilder<SonicQuery, Builder> {
        private final TimeConstraint timeConstraint;
        private int limit = 100;

        public Builder(TimeConstraint timeConstraint) {
            this.b = this;
            this.timeConstraint = timeConstraint;
        }

        public SonicQuery done() {
            KeyValueConstraint[] keyValueConstraints = this.keyValueConstraints.toArray(new KeyValueConstraint[0]);
            return new SonicQuery(this.timeConstraint, this.limit, keyValueConstraints);
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }
    }
}

