/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.core.shared.impl.memory;

import com.google.gwt.regexp.shared.RegExp;
import com.sonicmetrics.core.shared.ISonicPotentialEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicUtils;
import com.sonicmetrics.core.shared.util.ValidationUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;

public class SonicPotentialEvent
implements ISonicPotentialEvent,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String IDENTIFIER = "[0-9a-zA-Z][0-9a-zA-Z-_]{1,99}";
    public static final RegExp IDENTIFIER_PATTERN = ValidationUtils.compilePattern("[0-9a-zA-Z][0-9a-zA-Z-_]{1,99}");
    private static final Logger log = LoggerFactory.getLogger(SonicPotentialEvent.class);
    public static final String USERIDENTIFIER = "[0-9a-zA-Z-@.][0-9a-zA-Z-_@.]{1,100}";
    public static final RegExp USERIDENTIFIER_PATTERN = ValidationUtils.compilePattern("[0-9a-zA-Z-@.][0-9a-zA-Z-_@.]{1,100}");
    protected String action;
    protected String category;
    protected final Map<String, String> extensionDataMap = new HashMap<String, String>();
    protected String label;
    protected String source;
    protected String subject;
    protected String uniqueId;
    protected String value;

    public static SpeBuilder create() {
        return new SpeBuilder();
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getDotString() {
        return SonicUtils.toDotString(this.getCategory(), this.getAction(), this.getLabel());
    }

    @Override
    public Map<String, String> getExtensionData() {
        return Collections.unmodifiableMap(this.extensionDataMap);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean hasLabel() {
        return this.getLabel() != null;
    }

    @Override
    public boolean hasUniqueId() {
        return this.getUniqueId() != null;
    }

    public String toString() {
        return "subject:'" + this.subject + "':'" + this.category + "." + this.action + "." + this.label + (this.value == null ? "" : "=" + this.value) + "' source:'" + this.source + "'";
    }

    public int size() {
        return this.size(this.action) + this.size(this.category) + this.size(this.label) + this.size(this.source) + this.size(this.subject) + this.size(this.uniqueId) + this.size(this.value);
    }

    protected int size(String s) {
        return 1 + (s == null ? 0 : 2 + SonicPotentialEvent.length(s));
    }

    public static int length(CharSequence sequence) {
        int count = 0;
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char ch = sequence.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public static class SpeBuilder
    extends Builder<SonicPotentialEvent, SpeBuilder> {
        public SpeBuilder() {
            this.t = new SonicPotentialEvent();
            this.b = this;
        }

        @Override
        public void validate() {
            XyAssert.validateNotNull((Object)this.t.category, (String)"category");
            XyAssert.validateNotNull((Object)this.t.action, (String)"action");
            XyAssert.validateNotNull((Object)this.t.subject, (String)"subject");
            XyAssert.validateNotNull((Object)this.t.source, (String)"source");
        }
    }

    public static abstract class Builder<T extends SonicPotentialEvent, B extends Builder<T, B>> {
        protected T t;
        protected B b;

        public T build() {
            this.validate();
            return this.t;
        }

        protected void validate() {
        }

        public B action(String action) throws IllegalArgumentException {
            XyAssert.validateNotNull((Object)action, (String)"action");
            ((SonicPotentialEvent)this.t).action = action.toLowerCase();
            XyAssert.validateCondition((boolean)ValidationUtils.matches(IDENTIFIER_PATTERN, action), (String)"Action must be a valid Identifier, i.e. match the regex '[0-9a-zA-Z][0-9a-zA-Z-_]{1,99}' (Java syntax). See doc.sonicmetrics.com");
            return this.b;
        }

        public B category(String category) throws IllegalArgumentException {
            XyAssert.validateNotNull((Object)category, (String)"category");
            ((SonicPotentialEvent)this.t).category = category.toLowerCase();
            XyAssert.validateCondition((boolean)ValidationUtils.matches(IDENTIFIER_PATTERN, category), (String)"Category must be a valid Identifier, i.e. match the regex '[0-9a-zA-Z][0-9a-zA-Z-_]{1,99}' (Java syntax). See doc.sonicmetrics.com");
            return this.b;
        }

        public B label(String label) throws IllegalArgumentException {
            XyAssert.validateNotNull((Object)label, (String)"label");
            ((SonicPotentialEvent)this.t).label = label.toLowerCase();
            XyAssert.validateCondition((boolean)ValidationUtils.matches(IDENTIFIER_PATTERN, label), (String)"Label must be a valid Identifier, i.e. match the regex '[0-9a-zA-Z][0-9a-zA-Z-_]{1,99}' (Java syntax). See doc.sonicmetrics.com");
            return this.b;
        }

        public B labelIgnoreIfNull(String label) {
            if (label != null) {
                return this.label(label);
            }
            return this.b;
        }

        public B source(String source) throws IllegalArgumentException {
            XyAssert.validateNotNull((Object)source, (String)"source");
            ((SonicPotentialEvent)this.t).source = source.toLowerCase();
            XyAssert.validateCondition((boolean)ValidationUtils.matches(USERIDENTIFIER_PATTERN, source), (String)("Source must be a valid UserIdentifier, i.e. match the regex '" + USERIDENTIFIER_PATTERN.getSource() + "' (Java syntax). See doc.sonicmetrics.com"));
            return this.b;
        }

        public B subject(String subject) throws IllegalArgumentException {
            XyAssert.validateNotNull((Object)subject, (String)"subject");
            ((SonicPotentialEvent)this.t).subject = subject.toLowerCase();
            XyAssert.validateCondition((boolean)ValidationUtils.matches(USERIDENTIFIER_PATTERN, subject), (String)("Subject must be a valid UserIdentifier, i.e. match the regex '" + USERIDENTIFIER_PATTERN.getSource() + "' (Java syntax). See doc.sonicmetrics.com"));
            return this.b;
        }

        public B uniqueId(String uniqueId) {
            XyAssert.validateNotNull((Object)uniqueId, (String)"uniqueid");
            ((SonicPotentialEvent)this.t).uniqueId = uniqueId;
            return this.b;
        }

        public B uniqueIdIgnoredIfNull(String uniqueId) {
            if (uniqueId != null) {
                return this.uniqueId(uniqueId);
            }
            return this.b;
        }

        public B value(String value) {
            XyAssert.validateNotNull((Object)value, (String)"value");
            ((SonicPotentialEvent)this.t).value = value;
            return this.b;
        }

        public B valueIgnoreIfNull(String value) {
            if (value != null) {
                ((SonicPotentialEvent)this.t).value = value;
            }
            return this.b;
        }

        public B withParam(ISonicPotentialEvent.FilterProperty key, String value) {
            switch (key) {
                case Action: {
                    return this.action(value);
                }
                case Category: {
                    return this.category(value);
                }
                case Label: {
                    return this.label(value);
                }
                case Source: {
                    return this.source(value);
                }
                case Subject: {
                    return this.subject(value);
                }
                case Value: {
                    return this.value(value);
                }
            }
            throw new AssertionError();
        }

        public B withParam(String key, String value) throws IllegalArgumentException {
            if (value == null) {
                return this.b;
            }
            if (ValidationUtils.matches(IDENTIFIER_PATTERN, key)) {
                if (key.equalsIgnoreCase("category")) {
                    return this.category(value);
                }
                if (key.equalsIgnoreCase("action")) {
                    return this.action(value);
                }
                if (key.equalsIgnoreCase("label")) {
                    return this.label(value);
                }
                if (key.equalsIgnoreCase("value")) {
                    return this.value(value);
                }
                if (key.equalsIgnoreCase("subject")) {
                    return this.subject(value);
                }
                if (key.equalsIgnoreCase("source")) {
                    return this.source(value);
                }
                if (key.equalsIgnoreCase("uniqueid")) {
                    return this.uniqueId(value);
                }
                ((SonicPotentialEvent)this.t).extensionDataMap.put(key, value);
            } else {
                log.debug("Ignored invalid key '" + key + "'" + ". Did not match the regex '" + SonicPotentialEvent.IDENTIFIER + "' (Java syntax). See doc.sonicmetrics.com");
            }
            return this.b;
        }
    }
}

