/*
 * Decompiled with CFR 0.152.
 */
package de.xam.md5;

import de.xam.md5.MD5;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.xydra.annotations.LicenseLGPL;

@LicenseLGPL(licenseVersion="2.1")
public class MD5InputStream
extends FilterInputStream {
    private final MD5 md5 = new MD5();

    public MD5InputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            return -1;
        }
        if ((c & 0xFFFFFF00) != 0) {
            System.out.println("MD5InputStream.read() got character with (c & ~0xff) != 0)!");
        } else {
            this.md5.Update(c);
        }
        return c;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int r = this.in.read(bytes, offset, length);
        if (r == -1) {
            return r;
        }
        this.md5.Update(bytes, offset, r);
        return r;
    }

    public byte[] hash() {
        return this.md5.Final();
    }

    public MD5 getMD5() {
        return this.md5;
    }

    public static void main(String[] arg) {
        try {
            int num_read;
            String filename = arg[arg.length - 1];
            byte[] buf = new byte[65536];
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
            MessageDigest digest = MessageDigest.getInstance("MD5");
            while ((num_read = ((InputStream)in).read(buf)) != -1) {
                digest.update(buf, 0, num_read);
            }
            System.out.println(MD5.asHex(digest.digest()) + "  " + filename);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

