/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.item;

import de.xam.dwz1.webgui.DwzBaseVelocitySupport;
import de.xam.dwz1.webgui.server.item.ItemCommand;
import de.xam.dwzmodel.api.ConfParamsDwzModel;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.mybase.model.api.IMyBase;
import de.xam.p13n.shared.Personalisation;
import org.xydra.base.XId;
import org.xydra.restless.IRestlessContext;

public class ItemVelocitySupport
extends DwzBaseVelocitySupport {
    private int editEnd;
    private int editStart;
    private transient IEntity entity;
    private XId entityId;

    public static ItemVelocitySupport create(IRestlessContext ctx, XId entityId, IEntity entity, ItemCommand itemCommand) {
        assert (entityId != null);
        Personalisation p13n = ModuleManager.get().getPersonalisation();
        ItemVelocitySupport velocitySupport = new ItemVelocitySupport(p13n, ConfParamsDwzModel.MESSAGE_PACKAGES, ctx.getRequestIdentifier(), itemCommand, entityId, entity);
        return velocitySupport;
    }

    public ItemVelocitySupport(Personalisation p13n, String[] messagePackages, String requestId, ItemCommand itemCommand, XId itemId, IEntity entity) {
        super(p13n, messagePackages, requestId, "item", itemCommand.toString(), false);
        this.entityId = itemId;
        this.entity = entity;
    }

    public int getEditEnd() {
        return this.editEnd;
    }

    public int getEditStart() {
        return this.editStart;
    }

    public IItem getItem() {
        if (this.entity == null) {
            this.entity = this.getMyBase().itemSet().getEntityById(this.getItemId());
        }
        if (this.entity instanceof IItem) {
            return (IItem)this.entity;
        }
        return null;
    }

    public XId getItemId() {
        return this.entityId;
    }

    @Override
    public String getTitle() {
        IMyBase myBase = this.getMyBase();
        IItem item = myBase.itemSet().getItemById(this.entityId);
        if (item == null) {
            return "Unknown Id: " + this.entityId;
        }
        return this.getItem().getDisplayString() + " (Item" + (this.getAction().length() > 0 ? "-" + this.getAction() : "") + ")";
    }

    public void setEditEnd(int end) {
        this.editEnd = end;
    }

    public void setEditStart(int start) {
        this.editStart = start;
    }

    public void setItemId(XId itemId) {
        this.entityId = itemId;
    }
}

