/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gaemyadmin;

import com.google.appengine.api.utils.SystemProperty;
import org.xydra.gaemyadmin.GaeMyAdmin_GaeTestFixer_LocalPart;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class GaeMyAdmin_GaeTestfixer {
    private static final Logger log = LoggerFactory.getLogger(GaeMyAdmin_GaeTestfixer.class);
    private static boolean enabled = false;
    private static boolean checkedProduction = false;

    public static void enable() {
        log.debug("Enabling test fixer.");
        enabled = true;
        checkedProduction = false;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean inProduction() {
        return SystemProperty.environment.get() != null && SystemProperty.environment.value().equals((Object)SystemProperty.Environment.Value.Production);
    }

    public static void initialiseHelperAndAttachToCurrentThread() {
        if (!enabled) {
            return;
        }
        if (!checkedProduction) {
            log.debug("Testing if we are on the real GAE in production...");
            checkedProduction = true;
            if (GaeMyAdmin_GaeTestfixer.inProduction()) {
                log.debug("Testfixer: Running on AppEngine in production: Auto-disabled test fixer.");
                enabled = false;
                return;
            }
            log.debug("Testfixer: Running locally");
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class.forName("com.google.appengine.tools.development.testing.LocalServiceTestHelper", false, cl);
                log.debug("We can load the test classes.");
            }
            catch (ClassNotFoundException e) {
                log.warn("We are in fact in production (or a jar is missing): Auto-disabled test fixer.", (Throwable)e);
                enabled = false;
                return;
            }
            catch (NoClassDefFoundError e) {
                log.warn("We are in fact in production (or a jar is missing): Auto-disabled test fixer.", (Throwable)e);
                enabled = false;
                return;
            }
        }
        GaeMyAdmin_GaeTestFixer_LocalPart.initialiseHelperAndAttachToCurrentThread();
    }

    public static synchronized void tearDown() {
        GaeMyAdmin_GaeTestFixer_LocalPart.tearDown();
    }
}

