/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gaemyadmin;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.memcache.StrictErrorHandler;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.csv.impl.memory.CsvTable;
import org.xydra.csv.impl.memory.Row;
import org.xydra.gaemyadmin.AdminAuthUtils;
import org.xydra.gaemyadmin.AppConstants;
import org.xydra.gaemyadmin.GaeMyAdmin_GaeTestfixer;
import org.xydra.gaemyadmin.GaeMyUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.SharedHtmlUtils;

public class DatastoreAdminResource {
    private static final Logger log = LoggerFactory.getLogger(DatastoreAdminResource.class);
    static final String PAGE_NAME = "Datastore Admin";
    public static String URL;
    private static final String passwordPropertyNameInWebXml = "org.xydra.gaemyadmin.DatastoreAdminResource.password";

    public static void restless(Restless restless, String prefix) {
        URL = prefix + "/datastore";
        restless.addMethod(URL, "GET", DatastoreAdminResource.class, "index", true, new RestlessParameter[0]);
        restless.addMethod(URL + "/stats", "GET", DatastoreAdminResource.class, "stats", true, new RestlessParameter[]{new RestlessParameter("resultFormat", "text")});
        restless.addMethod(URL + "/deleteAll", "GET", DatastoreAdminResource.class, "deleteAll", true, new RestlessParameter[]{new RestlessParameter("confirm", "wrong")});
        restless.addMethod(URL + "/deleteKind", "GET", DatastoreAdminResource.class, "deleteKind", true, new RestlessParameter[]{new RestlessParameter("kind"), new RestlessParameter("confirm", "wrong")});
    }

    public void index(HttpServletResponse res, HttpServletRequest req) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Writer w = AppConstants.startPage(res, PAGE_NAME, "");
        w.write(SharedHtmlUtils.toOrderedList(Arrays.asList(SharedHtmlUtils.link((String)("/admin" + URL + "/stats"), (String)"Statistics"), SharedHtmlUtils.link((String)("/admin" + URL + "/deleteKind?kind="), (String)"Page to delete data of a certain kind - clicking this link just lists stats about data"), SharedHtmlUtils.link((String)("/admin" + URL + "/deleteAll"), (String)"Page to delete all data - clicking this link just lists stats about data"))));
        AppConstants.endPage(w);
    }

    public void deleteAll(IRestlessContext context, HttpServletResponse res, String confirmParam) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        AdminAuthUtils.setTempAuthCookie(context, passwordPropertyNameInWebXml);
        Writer w = AppConstants.startPage(res, PAGE_NAME, "Delete All");
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        List<String> kinds = GaeMyUtils.getAllKinds();
        for (String kind : kinds) {
            w.write("Kind '" + kind + "'. Counting ... ");
            Query q = new Query(kind).setKeysOnly();
            PreparedQuery pq = datastore.prepare(q);
            int count = pq.countEntities(FetchOptions.Builder.withDefaults());
            w.write(count + "\n");
        }
        String password = context.getRestless().getInitParameter(passwordPropertyNameInWebXml);
        w.write("Password is '" + password + "' it must match the URL param 'confirm' and the cookie. Setting cookie for 120 seconds ..." + "<br/>\n");
        try {
            AdminAuthUtils.checkIfAuthorised(context, passwordPropertyNameInWebXml, confirmParam);
            for (String kind : kinds) {
                w.write("Deleting kind " + kind + ". Getting keys ... ");
                w.flush();
                LinkedList<Key> keys = new LinkedList<Key>();
                Query q = new Query(kind).setKeysOnly();
                PreparedQuery pq = datastore.prepare(q);
                for (Entity entity : pq.asIterable()) {
                    keys.add(entity.getKey());
                }
                w.write("Bulk delete ... ");
                try {
                    datastore.delete(keys);
                }
                catch (Exception e) {
                    log.warn("Could not delete kind '" + kind + "'", (Throwable)e);
                    w.write("Could not delete kind '" + kind + "'.");
                }
                w.write("Deleted all '" + kind + "'.\n");
            }
            w.write("Done with delete all.\n");
        }
        catch (Exception e) {
            w.write("Ok, did not delete anything. If you are really sure, add '?confirm=....' to this url.");
        }
        AppConstants.endPage(w);
    }

    public void deleteKind(IRestlessContext context, HttpServletResponse res, String kind, String confirmParam) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Writer w = AppConstants.startPage(res, PAGE_NAME, "Delete Kind '" + kind + "'");
        AdminAuthUtils.setTempAuthCookie(context, passwordPropertyNameInWebXml);
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        w.write("Kind '" + kind + "'. Counting ... ");
        Query q = new Query(kind).setKeysOnly();
        PreparedQuery pq = datastore.prepare(q);
        int count = pq.countEntities(FetchOptions.Builder.withDefaults());
        w.write(count + "\n");
        String password = context.getRestless().getInitParameter(passwordPropertyNameInWebXml);
        w.write("Password is '" + password + "' it must match the URL param 'confirm' and the cookie. Setting cookie for 120 seconds ..." + "<br/>\n");
        try {
            AdminAuthUtils.checkIfAuthorised(context, passwordPropertyNameInWebXml, confirmParam);
            w.write("Deleting kind " + kind + ". Getting keys ... ");
            LinkedList<Key> keys = new LinkedList<Key>();
            q = new Query(kind).setKeysOnly();
            pq = datastore.prepare(q);
            for (Entity entity : pq.asIterable()) {
                keys.add(entity.getKey());
            }
            w.write("Bulk delete ... ");
            try {
                datastore.delete(keys);
            }
            catch (Exception e) {
                log.warn("Could not delete kind '" + kind + "'", (Throwable)e);
                w.write("Could not delete kind '" + kind + "'.");
            }
            w.write("Deleted all '" + kind + "'.\n");
        }
        catch (Exception e) {
            w.write("Ok, did not delete anything. If you are really sure, add '?confirm=....' to this url.");
        }
        AppConstants.endPage(w);
    }

    public void stats(HttpServletRequest req, String resultFormat, HttpServletResponse res) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Writer w = AppConstants.startPage(res, PAGE_NAME, "Stats");
        long start = System.currentTimeMillis();
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        w.write("<code><pre>");
        w.write("=== Version 2010-11-10 $Revision: 8152 $\n");
        DatastoreServiceConfig defaultConfig = DatastoreServiceConfig.Builder.withDefaults();
        w.write("Default datastore config\n* deadline: " + defaultConfig.getDeadline() + "\n" + "* implicitTransactionManagementPolicy: " + defaultConfig.getImplicitTransactionManagementPolicy().name() + "\n" + "* readPolicy: " + defaultConfig.getReadPolicy().getConsistency() + "\n");
        Key key = KeyFactory.createKey((String)"dummy", (String)"dummyEntity");
        Entity dummyEntity = new Entity(key);
        try {
            datastore.put(dummyEntity);
            w.write("Datastore health: Fully functional and writeable\n");
        }
        catch (ApiProxy.CapabilityDisabledException e) {
            w.write("Datastore health: /!\\ READ-ONLY MODE /!\\ \n");
        }
        MemcacheService ms = MemcacheServiceFactory.getMemcacheService();
        ms.setErrorHandler((ErrorHandler)new StrictErrorHandler());
        try {
            ms.put((Object)"dummy", (Object)"dummy");
            w.write("Memcache health:  Fully functional and writeable\n");
        }
        catch (MemcacheServiceException e) {
            w.write("Memcache health:  /!\\ READ-ONLY MODE /!\\ Will return no hits\n");
        }
        Collection txns = datastore.getActiveTransactions();
        w.write("Active transactions: " + txns.size() + "\n");
        FetchOptions defaultFetchOptions = FetchOptions.Builder.withDefaults();
        w.write("Default fetchOptions\n* chunkSize: " + defaultFetchOptions.getChunkSize() + "\n" + "* limit: " + defaultFetchOptions.getLimit() + "\n" + "* offset: " + defaultFetchOptions.getOffset() + "\n" + "* prefetchSize: " + defaultFetchOptions.getPrefetchSize() + "\n");
        if (resultFormat.equals("text")) {
            w.write("All kinds of entities\n");
            for (String kind : GaeMyUtils.getAllKinds()) {
                w.write("* Kind: " + kind + "\n");
                for (Entity e : GaeMyUtils.getEntitiesOfKind(kind)) {
                    w.write("** appid:" + e.getAppId() + " namespace:" + e.getNamespace() + " props:" + e.getProperties().keySet() + "\n");
                    Map props = e.getProperties();
                    for (Map.Entry me : props.entrySet()) {
                        w.write("*** " + (String)me.getKey() + " = " + me.getValue() + "\n");
                    }
                }
            }
        } else {
            CsvTable csv = new CsvTable();
            w.write("Fetching kind names...\n");
            for (String kind : GaeMyUtils.getAllKinds()) {
                w.write("Processing all elements of kind: " + kind + "\n");
                for (Entity e : GaeMyUtils.getEntitiesOfKind(kind)) {
                    Row row = csv.getOrCreateRow(e.getKey().toString(), true);
                    row.setValue("appid", e.getAppId(), true);
                    row.setValue("namespace", e.getNamespace(), true);
                    row.setValue("kind", e.getKind(), true);
                    if (e.getParent() != null) {
                        row.setValue("parentkey", e.getParent().toString(), true);
                    }
                    Map props = e.getProperties();
                    for (Map.Entry me : props.entrySet()) {
                        Object o = me.getValue();
                        String value = null;
                        if (o != null) {
                            value = o instanceof Text ? ((Text)o).getValue() : o.toString();
                        }
                        row.setValue("prop-" + (String)me.getKey(), value, true);
                        if (o == null) continue;
                        row.setValue("prop-" + (String)me.getKey() + "-type", o.getClass().getName(), true);
                    }
                }
            }
            w.write("--------- >8 ----- CSV \n");
            csv.writeTo(w);
            w.write("--------- >8 ----- CSV \n");
        }
        Entity statTotal = datastore.prepare(new Query("__Stat_Total__")).asSingleEntity();
        if (statTotal != null) {
            Long totalBytes = (Long)statTotal.getProperty("bytes");
            Long totalEntities = (Long)statTotal.getProperty("count");
            w.write("Datastore contains " + totalBytes + " bytes in " + totalEntities + " entities");
        } else {
            w.write("No entity named '__Stat_Total__' found. Works maybe only in production. Stats are computed only once a day.");
        }
        long stop = System.currentTimeMillis();
        w.write("Done processing in " + (stop - start) / 1000L + " seconds");
        w.write("</pre></code>");
        AppConstants.endPage(w);
    }
}

