/*
 * Decompiled with CFR 0.152.
 */
package de.xam.ksource.impl.itemtxt;

import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.service.ServiceState;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.impl.ItemSets;
import de.xam.ksource.ISource;
import de.xam.ksource.ISourceItem;
import de.xam.ksource.KSources;
import de.xam.ksource.VocabularySources;
import de.xam.ksource.impl.itemtxt.DataFileFormat;
import de.xam.ksource.impl.itemtxt.DataFileSourceItem;
import de.xam.ksource.impl.itemtxt.ExternalFileFormat;
import de.xam.vocabulary.Vocabularies;
import de.xam.vocabulary.Vocabulary;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xydra.base.XId;
import org.xydra.base.value.ValueType;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.common.NanoClock;
import org.xydra.conf.annotations.RequireConf;
import org.xydra.env.Env;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

@RequireConf(value={"sources-datafile-rootDir"})
public class DataFileSource
implements ISource {
    private static final Vocabulary _VOC = Vocabularies.create(null, DataFileSource.class);
    private static final Logger log = LoggerFactory.getLogger(DataFileSource.class);
    private File rootDir;
    private ServiceState serviceState = ServiceState.initial();
    private IItemSet itemSet;

    public static boolean isSupportedValueType(ValueType valueType) {
        switch (valueType) {
            case Boolean: 
            case Long: 
            case IdSet: 
            case String: {
                return true;
            }
            case Null: 
            case Integer: 
            case Address: 
            case AddressList: 
            case AddressSet: 
            case AddressSortedSet: 
            case Binary: 
            case BooleanList: 
            case Double: 
            case DoubleList: 
            case Id: 
            case IdList: 
            case IdSortedSet: 
            case IntegerList: 
            case LongList: 
            case StringList: 
            case StringSet: {
                return false;
            }
        }
        throw new AssertionError();
    }

    private static void showStats(String text, IItem sourceItem, int count, File f) {
        String stats = "Indexed " + count + " items; last was '" + f.getAbsolutePath() + "'";
        sourceItem.setAttribute(VocabularySources.ATTRIBUTE_SOURCE_INDEX_STATS, (XValue)XV.toValue((String)stats));
        log.info("Refreshed " + count + " " + text);
    }

    @Override
    public void addBuiltIns(IItemSet itemSet) {
        IChangeData changeData = ChangeDatas.createWithCreationDate_Now((String)"DataFileSourceItem", (String)"addBuiltins");
        IItem item = ItemSets.getOrCreateItemWithStringContent((IItemSet)itemSet, (XId)this.getId(), (String)this.getLabel(), (IChangeData)changeData);
        item.setIsReference(true);
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public XId getId() {
        return KSources.getSourceId(this);
    }

    private File[] getItemFiles() {
        return this.rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return DataFileFormat.isItemFile(f);
            }
        });
    }

    public String getLabel() {
        return "DataFileSource";
    }

    @Override
    public String getPrefix() {
        return "datafile";
    }

    public File getRootDir() {
        assert (this.rootDir != null);
        return this.rootDir;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    @Override
    public Vocabulary getVocabulary() {
        return _VOC;
    }

    @Override
    public void init(IItemSet itemSet) {
        String rootDirPath = Env.get().conf().getString("sources-datafile-rootDir");
        this.rootDir = new File(rootDirPath);
        this.itemSet = itemSet;
    }

    @Override
    public Iterator<ISourceItem> iterator() {
        File[] files = this.getItemFiles();
        return Iterators.transform(Arrays.asList(files).iterator(), (ITransformer)new ITransformer<File, ISourceItem>(){

            public DataFileSourceItem transform(File f) {
                return new DataFileSourceItem(DataFileSource.this, f);
            }
        });
    }

    @Override
    public Map<XId, String> shouldPersistInExternalFile() {
        return new HashMap<XId, String>();
    }

    @Override
    public int size() {
        return this.getItemFiles().length;
    }

    @Override
    public void start() {
        Object f;
        int i;
        this.serviceState = this.serviceState.goTo(ServiceState.running);
        log.info("Refreshing source " + this.getPrefix());
        NanoClock clock = new NanoClock();
        clock.start();
        XId sourceId = KSources.getSourceId(this);
        IItem sourceItem = this.itemSet.getItemById(sourceId);
        assert (sourceItem != null) : "no source item with id '" + sourceId + "'";
        clock.stopAndStart("add-metadata");
        Object[] files = this.rootDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        });
        Arrays.sort(files);
        int count = 0;
        for (i = 0; i < files.length && this.getServiceState().shouldRun(); ++i) {
            f = files[i];
            if (DataFileFormat.isItemFile((File)f)) {
                XId id = DataFileSourceItem.toId((File)f);
                try {
                    DataFileSourceItem.readDataFromItemFileToMyBase((File)f, id, this.itemSet);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error", e);
                }
                ++count;
            }
            if (count % 250 != 0 && i + 1 != files.length) continue;
            DataFileSource.showStats("items", sourceItem, count, (File)f);
        }
        count = 0;
        for (i = 0; i < files.length && this.getServiceState().shouldRun(); ++i) {
            f = files[i];
            if (DataFileFormat.isItemFile((File)f) || ((File)f).getName().endsWith(".xml")) continue;
            try {
                ExternalFileFormat.tryToReadAsHelperFileToMyBase((File)f, DataFileSourceItem.writeMyBase(this.itemSet));
            }
            catch (IOException e) {
                throw new RuntimeException("Error", e);
            }
            if (++count % 250 != 0 && i + 1 != files.length) continue;
            DataFileSource.showStats("property helper files", sourceItem, count, (File)f);
        }
        clock.stopAndStart("index-all-sourceitems");
        log.info("done indexing source '" + this.getPrefix() + "'; stats=" + clock.getStats());
        this.serviceState = this.serviceState.goTo(ServiceState.stopped);
    }

    public void stop() {
        this.serviceState = this.serviceState.goTo(ServiceState.stopped);
    }

    public void writeBackToSource(IItemSet myBase) throws UnsupportedOperationException, IOException {
        Iterator it = myBase.items();
        while (it.hasNext()) {
            IItem item = (IItem)it.next();
            log.trace("writing " + item.getId());
            DataFileSourceItem dsi = new DataFileSourceItem(this, item.getId());
            dsi.writeBackToSource(myBase);
        }
    }
}

