/*
 * Decompiled with CFR 0.152.
 */
package de.xam.p13n.shared.time;

import de.xam.p13n.shared.time.TzDatabase;
import java.io.Serializable;

public class MiniTimeZone
implements Serializable {
    private static final long serialVersionUID = -3608883372057165964L;
    public static final MiniTimeZone GERMANY_BERLIN = new MiniTimeZone("Europe/Berlin", 1);
    public static final MiniTimeZone US_SAN_FRANCISCO = new MiniTimeZone("America/Los_Angeles", -8);
    public static final String TIMEZONE_ID_UNKNOWN = "Unknown";
    private String timeZoneId;
    private int utcOffset;

    public static MiniTimeZone fromString(String timeZoneString) {
        int lastSlash = timeZoneString.lastIndexOf("/");
        if (lastSlash <= 0) {
            throw new IllegalArgumentException("No slash / found");
        }
        String timeZoneId = timeZoneString.substring(0, lastSlash);
        String offset = timeZoneString.substring(lastSlash + 1);
        try {
            if (offset.startsWith("+")) {
                offset = offset.substring(1);
            }
            int utcOffset = (int)Long.parseLong(offset);
            return new MiniTimeZone(timeZoneId, utcOffset);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MiniTimeZone() {
    }

    public MiniTimeZone(int utcOffset) {
        this.utcOffset = utcOffset;
        this.timeZoneId = TIMEZONE_ID_UNKNOWN;
    }

    public MiniTimeZone(String timeZoneId, int utcOffset) {
        this.timeZoneId = timeZoneId;
        this.utcOffset = utcOffset;
    }

    public boolean equals(Object other) {
        return other instanceof MiniTimeZone && ((MiniTimeZone)other).timeZoneId.equalsIgnoreCase(this.timeZoneId);
    }

    public String getCountryCode() {
        return TzDatabase.getEntryForTimeZoneName((String)this.timeZoneId).countryCode;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    public int hashCode() {
        return this.timeZoneId.hashCode();
    }

    public String toCompactString() {
        return this.timeZoneId + "/" + this.utcOffset;
    }
}

