/*
 * Decompiled with CFR 0.152.
 */
package de.xam.p13n.server;

import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.SharedLocaleUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class LocaleUtils
extends SharedLocaleUtils {
    private static final Logger log = LoggerFactory.getLogger(LocaleUtils.class);
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";

    public static List<LangDef> parseAcceptLanguageHeader(String acceptLanguageHeader) {
        AcceptLanguage acceptLanguage = new AcceptLanguage(acceptLanguageHeader);
        return acceptLanguage.langDefs;
    }

    public static List<Locale> getLocalesFromBrowser(HttpServletRequest req) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Enumeration e = req.getHeaders(HEADER_ACCEPT_LANGUAGE);
        while (e.hasMoreElements()) {
            String acceptLanguageHeader = (String)e.nextElement();
            List<LangDef> langDefs = LocaleUtils.parseAcceptLanguageHeader(acceptLanguageHeader);
            for (LangDef l : langDefs) {
                Locale loc = new Locale(l.getLang());
                locales.add(loc);
            }
        }
        return locales;
    }

    public static String toString(Locale locale, int precision) {
        StringBuffer buf = new StringBuffer();
        if (precision > 0) {
            buf.append(locale.getLanguage().toLowerCase());
            if (precision > 1) {
                if (locale.getCountry() != null && !locale.getCountry().equals("")) {
                    buf.append("_");
                    buf.append(locale.getCountry().toLowerCase());
                }
                if (precision > 2 && locale.getVariant() != null && !locale.getVariant().equals("")) {
                    buf.append("_");
                    buf.append(locale.getVariant().toLowerCase());
                }
            }
        }
        return buf.toString();
    }

    public static MiniLocale getLocale(File f) {
        if (f.getName().equals("MSG.utf8")) {
            return LocaleUtils.getRootLocale();
        }
        String fName = f.getAbsolutePath();
        String ext = ".utf8";
        assert (fName.endsWith(".utf8"));
        int firstUnderscore = (fName = fName.substring(0, fName.length() - ".utf8".length())).indexOf(95);
        if (firstUnderscore <= 0) {
            return null;
        }
        fName = fName.substring(firstUnderscore + 1);
        MiniLocale locale = LocaleUtils.fromString(fName);
        return locale;
    }

    public static Locale toJavaLocale(MiniLocale miniLocale) {
        if (miniLocale.getLanguage() == null) {
            return new Locale(miniLocale.getCountry());
        }
        if (miniLocale.getVariant() == null) {
            return new Locale(miniLocale.getCountry(), miniLocale.getLanguage());
        }
        return new Locale(miniLocale.getCountry(), miniLocale.getLanguage(), miniLocale.getVariant());
    }

    public static class LangDef
    implements Comparable<LangDef> {
        private String lang;
        private double q;

        public LangDef(String def) {
            String[] pair = def.split(";");
            if (pair.length > 2) {
                throw new IllegalArgumentException("More than two parts in '" + def + "'");
            }
            if (pair.length == 1) {
                this.lang = def.trim();
                this.q = 1.0;
            } else if (pair.length == 2) {
                this.lang = pair[0].trim();
                try {
                    this.q = Double.parseDouble(pair[1].trim());
                    if (this.q < 0.0 || this.q > 1.0) {
                        log.warn("Malformed q-value in Accept-Language '" + pair[1] + "'");
                        this.q = 0.5;
                    }
                }
                catch (NumberFormatException e) {
                    this.q = 0.5;
                }
            }
        }

        public String getLang() {
            return this.lang;
        }

        public double getFactor() {
            return this.q;
        }

        @Override
        public int compareTo(LangDef o) {
            return (int)Math.signum(this.q - o.q);
        }
    }

    private static class AcceptLanguage {
        private final List<LangDef> langDefs = new LinkedList<LangDef>();

        public AcceptLanguage(String acceptLanguageHeader) {
            String[] defs;
            if (acceptLanguageHeader == null) {
                return;
            }
            for (String def : defs = acceptLanguageHeader.split(",")) {
                try {
                    LangDef langDef = new LangDef(def);
                    this.langDefs.add(langDef);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            Collections.sort(this.langDefs);
        }
    }
}

