/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class HostUtils {
    public static final Logger log = LoggerFactory.getLogger(HostUtils.class);
    private static String hostname = null;
    private static String ipaddress = null;

    public static String getLocalUserName() {
        return System.getProperty("user.name");
    }

    public static synchronized String getLocalHostname() {
        if (hostname == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostname = addr.getHostName();
            }
            catch (UnknownHostException e) {
                log.warn("Sorry, could not create a better localhost name than 'localhost'");
                hostname = "localhost";
            }
        }
        return hostname;
    }

    public static synchronized String getLocalHostnameOrNull() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
            return hostname;
        }
        catch (UnknownHostException e) {
            log.warn("Sorry, could not obtain hostname", (Throwable)e);
            return null;
        }
    }

    public static synchronized String getLocalIpAddress() {
        if (ipaddress == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                ipaddress = addr.getHostAddress();
            }
            catch (UnknownHostException e) {
                log.warn("Sorry, could not create a better IP address than '127.0.0.1'");
                ipaddress = "127.0.0.1";
            }
        }
        return ipaddress;
    }

    public static int getRequestPort(HttpServletRequest req) {
        return req.getServerPort();
    }

    public static String getServernameWithPort(HttpServletRequest req) {
        int port = HostUtils.getRequestPort(req);
        String hostname = HostUtils.isLocalRequest(req) ? HostUtils.getLocalIpAddress() : req.getServerName();
        return hostname + (port == 80 ? "" : ":" + port);
    }

    public static boolean isLocalRequest(HttpServletRequest req) {
        String serverName = req.getServerName();
        log.debug("serverName = " + serverName);
        return serverName.equals("127.0.0.1") || serverName.equals("localhost") || serverName.equals(HostUtils.getLocalHostname());
    }

    public static void main(String[] args) {
        System.out.println(HostUtils.getLocalIpAddress() + " = " + HostUtils.getLocalHostname());
    }
}

