/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.xydra.restless.utils.HostUtils;

class TweakedRequest
extends HttpServletRequestWrapper {
    private boolean initalised = false;
    private String hostOverride = null;
    private String pathInfo = null;

    public TweakedRequest(HttpServletRequest baseReq) {
        super(baseReq);
    }

    public synchronized String getServerName() {
        if (!this.initalised) {
            this.initialise();
        }
        return this.hostOverride;
    }

    public synchronized String getPathInfo() {
        if (!this.initalised) {
            this.initialise();
        }
        return this.pathInfo;
    }

    private void initialise() {
        this.initalised = true;
        String serverName = super.getServerName();
        assert (TweakedRequest.isLocalhost(serverName));
        this.hostOverride = super.getParameter("X-HTTP-Host-Override");
        String superPathInfo = super.getPathInfo();
        if (superPathInfo != null) {
            StringBuffer adaptedPathInfo = new StringBuffer();
            if (superPathInfo.startsWith("/")) {
                adaptedPathInfo.append("/");
            }
            String[] parts = superPathInfo.split("/");
            boolean hadSignificantPart = false;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part.startsWith("X-HTTP-Host-Override=")) {
                    this.hostOverride = part.substring("X-HTTP-Host-Override".length() + 1);
                    continue;
                }
                if (part.length() <= 0) continue;
                if (i > 0 && hadSignificantPart) {
                    adaptedPathInfo.append("/");
                }
                adaptedPathInfo.append(part);
                hadSignificantPart = true;
            }
            if (superPathInfo.endsWith("/")) {
                adaptedPathInfo.append("/");
            }
            this.pathInfo = adaptedPathInfo.toString();
        }
        if (this.hostOverride == null) {
            this.hostOverride = serverName;
        }
    }

    static boolean isLocalhost(String serverName) {
        if (serverName == null) {
            return false;
        }
        return serverName.equals("localhost") || serverName.equals("127.0.0.1") || serverName.equals(HostUtils.getLocalHostname());
    }
}

