/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.xydra.common.NanoClock;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.spi.ILoggerFactorySPI;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.PathTemplate;
import org.xydra.restless.ProgressManager;
import org.xydra.restless.RestlessContextImpl;
import org.xydra.restless.RestlessExceptionHandler;
import org.xydra.restless.RestlessMethod;
import org.xydra.restless.RestlessMethodExecutionParameters;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.RestlessStatic;
import org.xydra.restless.RestlessUnloadHandler;
import org.xydra.restless.TweakedRequest;
import org.xydra.restless.utils.HtmlUtils;
import org.xydra.restless.utils.ServletUtils;
import org.xydra.restless.utils.XmlUtils;

public class Restless
extends HttpServlet {
    static Logger log;
    public static final String ADMIN_ONLY_URL_PREFIX = "/admin";
    public static final String CONTENT_TYPE_CHARSET_UTF8 = "utf-8";
    public static boolean DELEGATE_UNHANDLED_TO_DEFAULT;
    public static final String INIT_PARAM_APP = "app";
    public static final String INIT_PARAM_XYDRA_LOG_BACKEND = "loggerFactory";
    public static final String INIT_PARAM_404RESOURCE = "error404";
    public static final String JAVA_ENCODING_UTF8 = "utf-8";
    public static final String MIME_TEXT_PLAIN = "text/plain";
    public static final String MIME_XHTML = "application/xhtml+xml";
    private static final long serialVersionUID = -1906300614203565189L;
    public static String X_FRAME_OPTIONS_DEFAULT;
    public static final String X_FRAME_OPTIONS_HEADERNAME = "X-Frame-Options";
    public static final String X_HOST_Override = "X-HTTP-Host-Override";
    public static final String X_HTTP_Method_Override = "X-HTTP-Method-Override";
    public static final String XHTML_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">";
    public static final String XHTML_NS = "xmlns=\"http://www.w3.org/1999/xhtml\"";
    public static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String INTROSPECTION_PATH = "/admin/restless";
    private String apps;
    final List<RestlessExceptionHandler> exceptionHandlers = new LinkedList<RestlessExceptionHandler>();
    final List<RestlessUnloadHandler> unloadHandlers = new LinkedList<RestlessUnloadHandler>();
    private final Map<String, String> initParams = new HashMap<String, String>();
    private HashMap<String, Object> localContext;
    private String loggerFactory;
    private final List<RestlessMethod> methods = new LinkedList<RestlessMethod>();
    private final Set<IRequestListener> requestListeners = new HashSet<IRequestListener>();
    private ServletContext servletContext;
    private final Object serviceLock = new Object();
    private int serviceCounter = 0;
    private boolean shuttingDown = false;
    private String error404resourceClassname = null;
    private static final Class<?>[] RESTLESS_METHOD_PARAMETERS;

    public boolean hasCustomError404HandlerDefined() {
        return this.error404resourceClassname != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptionHandler(RestlessExceptionHandler handler) {
        List<RestlessExceptionHandler> list = this.exceptionHandlers;
        synchronized (list) {
            this.exceptionHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnloadHandler(RestlessUnloadHandler handler) {
        List<RestlessUnloadHandler> list = this.unloadHandlers;
        synchronized (list) {
            this.unloadHandlers.add(handler);
        }
    }

    public void addGet(String pathTemplate, Object instanceOrClass, String javaMethodName, RestlessParameter ... parameter) {
        this.addMethod(pathTemplate, "GET", instanceOrClass, javaMethodName, false, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(String pathTemplate, String httpMethod, Object instanceOrClass, String javaMethodName, boolean adminOnly, RestlessParameter ... parameter) {
        PathTemplate pt = new PathTemplate(pathTemplate);
        List<RestlessMethod> list = this.methods;
        synchronized (list) {
            RestlessMethod restlessMethod = new RestlessMethod(instanceOrClass, httpMethod, javaMethodName, pt, adminOnly, parameter);
            this.methods.add(restlessMethod);
            log.debug("Add method " + restlessMethod);
        }
        assert (RestlessStatic.methodByName(instanceOrClass, javaMethodName) != null) : "method '" + javaMethodName + "' not found in " + instanceOrClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostMultipart(String pathTemplate, Object instanceOrClass, String javaMethodName, boolean adminOnly, RestlessParameter ... parameter) {
        PathTemplate pt = new PathTemplate(pathTemplate);
        List<RestlessMethod> list = this.methods;
        synchronized (list) {
            RestlessMethod restlessMethod = new RestlessMethod(instanceOrClass, "POST", javaMethodName, pt, adminOnly, parameter);
            this.methods.add(restlessMethod);
            log.debug("Add post/multipart method " + restlessMethod);
        }
        assert (RestlessStatic.methodByName(instanceOrClass, javaMethodName) != null) : "method '" + javaMethodName + "' not found in " + instanceOrClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestListener(IRequestListener requestListener) {
        Set<IRequestListener> set = this.requestListeners;
        synchronized (set) {
            this.requestListeners.add(requestListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delegateToDefaultServlet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            ServletContext sc;
            ServletContext servletContext = sc = this.getServletContext();
            synchronized (servletContext) {
                RequestDispatcher rd = sc.getNamedDispatcher("default");
                if (rd == null) {
                    rd = sc.getNamedDispatcher("_ah_default");
                }
                HttpServletRequestWrapper wrapped = new HttpServletRequestWrapper(req){

                    public String getServletPath() {
                        return "";
                    }
                };
                rd.forward((ServletRequest)wrapped, (ServletResponse)res);
            }
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) {
        if (log.isDebugEnabled()) {
            Thread.currentThread().setName("Restless DELETE " + req.getRequestURI());
        }
        this.restlessService(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        String uri = req.getRequestURI();
        if (log.isDebugEnabled()) {
            Thread.currentThread().setName("Restless GET " + uri);
        }
        if (uri.startsWith(INTROSPECTION_PATH)) {
            this.doIntrospection(req, res);
        } else {
            this.restlessService(req, res);
        }
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) {
        if (log.isDebugEnabled()) {
            Thread.currentThread().setName("Restless HEAD " + req.getRequestURI());
        }
        try {
            super.doHead(req, res);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIntrospection(HttpServletRequest req, HttpServletResponse res) {
        String servletPath = RestlessStatic.getServletPath(req);
        ServletUtils.headers(res, MIME_XHTML);
        try {
            PrintWriter w = res.getWriter();
            ((Writer)w).write(XHTML_DOCTYPE);
            ((Writer)w).write("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<title>Restless Configuration</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n<style type='text/css'> \nbody { font-family: Verdana,sans-serif; }\n</style>\n</head><body><div>");
            ((Writer)w).write("<h3>Restless configuration</h3>\n");
            ((Writer)w).write("<ol>");
            List<RestlessMethod> list = this.methods;
            synchronized (list) {
                for (RestlessMethod rm : this.methods) {
                    ((Writer)w).write("<li>");
                    String url = servletPath + XmlUtils.xmlEncode(rm.getPathTemplate().getRegex());
                    ((Writer)w).write((rm.isAdminOnly() ? "ADMIN ONLY" : "PUBLIC") + " resource <b class='resource'>" + url + "</b>: " + rm.getHttpMethod() + " =&gt; ");
                    ((Writer)w).write(RestlessStatic.instanceOrClass_className(rm.getInstanceOrClass()) + "#" + rm.getMethodName());
                    ((Writer)w).write("<form action='" + url + "' method='" + rm.getHttpMethod().toLowerCase() + "'><div>");
                    for (RestlessParameter parameter : rm.getRequiredNamedParameter()) {
                        ((Writer)w).write(parameter.getName() + " <input type='text' name='" + parameter.getName() + "' value='" + parameter.getDefaultValue() + "' />");
                    }
                    ((Writer)w).write("<input type='submit' value='Send' /></div></form>");
                    ((Writer)w).write("</li>\n");
                }
            }
            ((Writer)w).write("</ol>");
            HtmlUtils.endHtmlPage(w);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toConfigDebug() {
        List<RestlessMethod> list = this.methods;
        synchronized (list) {
            StringBuilder b = new StringBuilder();
            for (RestlessMethod rm : this.methods) {
                String url = XmlUtils.xmlEncode(rm.getPathTemplate().getRegex());
                b.append((rm.isAdminOnly() ? "ADMIN ONLY" : "PUBLIC") + " [" + url + "] " + rm.getHttpMethod() + " => ");
                b.append(RestlessStatic.instanceOrClass_className(rm.getInstanceOrClass()) + "#" + rm.getMethodName() + "\n");
                b.append("  ");
                for (RestlessParameter parameter : rm.getRequiredNamedParameter()) {
                    b.append(parameter.getName() + "='" + parameter.getDefaultValue() + "' ");
                }
                b.append("\n");
            }
            return b.toString();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        if (log.isDebugEnabled()) {
            Thread.currentThread().setName("Restless POST " + req.getRequestURI());
        }
        this.restlessService(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) {
        if (log.isDebugEnabled()) {
            Thread.currentThread().setName("Restless PUT " + req.getRequestURI());
        }
        this.restlessService(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRequestFinished(IRestlessContext restlessContext) {
        Set<IRequestListener> set = this.requestListeners;
        synchronized (set) {
            for (IRequestListener requestListener : this.requestListeners) {
                requestListener.onRequestFinished(restlessContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRequestStarted(IRestlessContext restlessContext) {
        Set<IRequestListener> set = this.requestListeners;
        synchronized (set) {
            for (IRequestListener requestListener : this.requestListeners) {
                requestListener.onRequestStarted(restlessContext);
            }
        }
    }

    public String getApp() {
        return this.apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getServletContextAttribute(String key) {
        try {
            ServletContext sc;
            ServletContext servletContext = sc = this.getServletContext();
            synchronized (servletContext) {
                return sc.getAttribute(key);
            }
        }
        catch (NullPointerException e) {
            if (this.localContext == null) {
                return null;
            }
            HashMap<String, Object> hashMap = this.localContext;
            synchronized (hashMap) {
                return this.localContext.get(key);
            }
        }
    }

    public ServletContext getServletContextFromInit() {
        return this.servletContext;
    }

    public Map<String, String> getWebXmlInitParameter() {
        return this.initParams;
    }

    public void init(ServletConfig servletConfig) {
        NanoClock clock = new NanoClock();
        clock.start();
        try {
            super.init(servletConfig);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not initialise super servlet", e);
        }
        clock.stopAndStart("super.init");
        this.loggerFactory = servletConfig.getInitParameter(INIT_PARAM_XYDRA_LOG_BACKEND);
        if (this.loggerFactory != null) {
            this.initLoggerFactory();
        }
        clock.stopAndStart("logger-init");
        log = LoggerFactory.getThreadSafeLogger(Restless.class);
        log.info("Restless: Init. Logging runs. Loading apps...");
        this.servletContext = servletConfig.getServletContext();
        Enumeration enumeration = servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = servletConfig.getInitParameter(key);
            this.initParams.put(key, value);
        }
        this.initParams.put("context:contextPath", servletConfig.getServletContext().getContextPath());
        this.initParams.put("context:realPath of '/'", servletConfig.getServletContext().getRealPath("/"));
        this.initParams.put("context:servletContextName", servletConfig.getServletContext().getServletContextName());
        this.initParams.put("context:serverInfo", servletConfig.getServletContext().getServerInfo());
        this.apps = this.initParams.get(INIT_PARAM_APP);
        this.error404resourceClassname = this.initParams.get(INIT_PARAM_404RESOURCE);
        List<String> appClassNames = RestlessStatic.parseToList(this.apps);
        clock.stop("param-parsing");
        for (String appClassName : appClassNames) {
            log.info("Restless: Loading restless app '" + appClassName + "'...");
            try {
                clock.start();
                String stats = this.instatiateAndInit(appClassName);
                clock.stop("init-app-" + appClassName);
                clock.append(" { ").append(stats).append(" } ");
                log.debug("Restless: ... done loading restless app '" + appClassName + "'.");
            }
            catch (Exception e) {
                log.error("Failed to init Restless app '" + appClassName + "' ", (Throwable)e);
            }
        }
        log.info("Restless: Adding built-in services ...");
        clock.start();
        ProgressManager.restless(this);
        clock.stop("add-built-in-services");
        if (log.isDebugEnabled()) {
            for (RestlessMethod rm : this.methods) {
                log.debug("Mapping " + rm.getHttpMethod() + " " + rm.getPathTemplate().getRegex() + " --> " + RestlessStatic.instanceOrClass_className(rm.getInstanceOrClass()) + "#" + rm.getMethodName() + " access:" + (rm.isAdminOnly() ? "ADMIN ONLY" : "PUBLIC"));
            }
        }
        log.info("Done Restless init at context path '" + this.initParams.get("context:contextPath") + "'. Admin interface at '" + this.initParams.get("context:contextPath") + "/admin/restless'. ");
        log.debug("Init performance " + clock.getStats());
    }

    private void initLoggerFactory() {
        if (LoggerFactory.hasLoggerFactorySPI()) {
            return;
        }
        try {
            Class<?> loggerFactoryClass = Class.forName(this.loggerFactory);
            try {
                Constructor<?> constructor = loggerFactoryClass.getConstructor(new Class[0]);
                try {
                    Object instance = constructor.newInstance(new Object[0]);
                    try {
                        ILoggerFactorySPI spi = (ILoggerFactorySPI)instance;
                        LoggerFactory.setLoggerFactorySPI((ILoggerFactorySPI)spi, (String)"Restless from web.xml/param:loggerFactory");
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException("Given loggerFactory class is not an implementation of ILoggerFactorySPI", e);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Could not instantiate loggerFactory class", e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Could not instantiate loggerFactory class", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Could not instantiate loggerFactory class", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Could not instantiate loggerFactory class", e);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Could not get constructor of loggerFactory class", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Found no parameterless constructor in loggerFactory class", e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load loggerFactory class", e);
        }
    }

    private String instatiateAndInit(String appClassName) throws RuntimeException {
        NanoClock clock = new NanoClock();
        RestlessStatic.invokeStaticMethod(clock, appClassName, "restless", RESTLESS_METHOD_PARAMETERS, new Object[]{this, ""});
        return clock.getStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestListener(IRequestListener requestListener) {
        Set<IRequestListener> set = this.requestListeners;
        synchronized (set) {
            this.requestListeners.remove(requestListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.enteringServiceMethod();
        try {
            super.service(req, res);
        }
        finally {
            this.leavingServiceMethod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enteringServiceMethod() {
        Object object = this.serviceLock;
        synchronized (object) {
            ++this.serviceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leavingServiceMethod() {
        Object object = this.serviceLock;
        synchronized (object) {
            --this.serviceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int numServices() {
        Object object = this.serviceLock;
        synchronized (object) {
            return this.serviceCounter;
        }
    }

    private void setShuttingDown() {
        this.shuttingDown = true;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.setShuttingDown();
        try {
            while (this.numServices() > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
        finally {
            try {
                for (RestlessUnloadHandler ruh : this.unloadHandlers) {
                    ruh.onBeforeUnload();
                }
            }
            finally {
                super.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restlessService(HttpServletRequest req, HttpServletResponse res) {
        NanoClock requestClock = new NanoClock().start();
        boolean runningOnLocalhost = TweakedRequest.isLocalhost(req.getServerName());
        Object reqHandedDown = runningOnLocalhost ? new TweakedRequest(req) : req;
        String path = reqHandedDown.getPathInfo();
        if (path == null) {
            path = "/";
        }
        boolean foundPath = false;
        boolean foundMethod = false;
        String httpMethod = reqHandedDown.getHeader(X_HTTP_Method_Override);
        if (httpMethod == null && reqHandedDown.getMethod().equals("GET")) {
            httpMethod = reqHandedDown.getParameter(X_HTTP_Method_Override);
        }
        if (httpMethod == null) {
            httpMethod = reqHandedDown.getMethod();
        }
        boolean reqViaAdminUrl = RestlessStatic.requestIsViaAdminUrl(reqHandedDown);
        RestlessMethodExecutionParameters params = null;
        RestlessMethod restlessMethod = null;
        List<RestlessMethod> list = this.methods;
        synchronized (list) {
            for (RestlessMethod m : this.methods) {
                if (reqViaAdminUrl != m.isAdminOnly() || !m.getPathTemplate().matches(path)) continue;
                foundPath = true;
                if (!httpMethod.equalsIgnoreCase(m.getHttpMethod())) continue;
                try {
                    params = m.prepareMethodExecution(this, (HttpServletRequest)reqHandedDown, res, requestClock);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (params == null) continue;
                restlessMethod = m;
                foundMethod = true;
                break;
            }
        }
        if (restlessMethod != null) {
            assert (params != null);
            assert (foundMethod);
            try {
                restlessMethod.execute(params, this, (HttpServletRequest)reqHandedDown, res);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!foundMethod) {
            if (this.hasCustomError404HandlerDefined()) {
                log.info("Launching custom error404 handler: " + this.error404resourceClassname + " for request on path '" + path + "'");
                RestlessContextImpl restlessContext = new RestlessContextImpl(this, req, res, "error-" + UUID.randomUUID());
                RestlessStatic.invokeStaticMethod(this.error404resourceClassname, INIT_PARAM_404RESOURCE, new Class[]{IRestlessContext.class}, new Object[]{restlessContext});
            } else {
                if (DELEGATE_UNHANDLED_TO_DEFAULT) {
                    log.info("Delegateto default");
                    try {
                        this.delegateToDefaultServlet((HttpServletRequest)reqHandedDown, res);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                String msg = "No handler matched your " + reqHandedDown.getMethod() + "-request path '" + path + "'. " + (foundPath ? "Found at least one path mapping (wrong HTTP method or missing parameters)." : "Found not even a path mapping. Check your Restless App and web.xml.");
                log.warn(msg);
                try {
                    res.sendError(404, msg);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        try {
            res.flushBuffer();
        }
        catch (IOException e) {
            // empty catch block
        }
        long requestTime = requestClock.stop("done").getDurationSinceStart();
        log.info("Took " + String.format("%5d", requestTime) + "ms for request to '" + req.getRequestURI() + "'");
        log.debug("Timing stats for request to '" + req.getRequestURI() + "': " + requestClock.getStats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServletContextAttribute(String key, Object value) {
        try {
            ServletContext sc;
            ServletContext servletContext = sc = this.getServletContext();
            synchronized (servletContext) {
                sc.setAttribute(key, value);
            }
        }
        catch (NullPointerException e) {
            if (this.localContext == null) {
                this.localContext = new HashMap();
            }
            HashMap<String, Object> hashMap = this.localContext;
            synchronized (hashMap) {
                this.localContext.put(key, value);
            }
        }
    }

    static {
        DELEGATE_UNHANDLED_TO_DEFAULT = false;
        X_FRAME_OPTIONS_DEFAULT = "sameorigin";
        RESTLESS_METHOD_PARAMETERS = new Class[]{Restless.class, String.class};
    }

    public static interface IRequestListener {
        public void onRequestFinished(IRestlessContext var1);

        public void onRequestStarted(IRestlessContext var1);
    }
}

