/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms.impl;

import com.calpano.common.client.view.forms.IBelongsToHtml5Form;
import com.calpano.common.client.view.forms.impl.Html5FormPanel;
import com.calpano.common.client.view.forms.locking.ILockable;
import com.calpano.common.client.view.forms.locking.impl.LockUtils;
import com.calpano.common.client.view.resources.CommonResourceBundle;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Html5SubmitButton
extends Button
implements IBelongsToHtml5Form,
ILockable {
    private static final Logger log = LoggerFactory.getLogger(Html5SubmitButton.class);
    private boolean disabled = false;
    private Html5FormPanel form;

    public Html5SubmitButton() {
        this.sinkEvents(771);
    }

    @Override
    public Html5FormPanel getForm() {
        return this.form;
    }

    @Override
    public void lock() {
        LockUtils.lock((Widget)this);
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        if (!this.isEnabled()) {
            log.warn("rejected click on disabled button");
            return;
        }
        switch (event.getTypeInt()) {
            case 128: 
            case 256: 
            case 512: {
                if (event.getKeyCode() != 13) break;
            }
            case 1: 
            case 2: {
                this.form.tryToSubmit(this);
            }
        }
    }

    @Override
    public void resetLockState() {
        this.setEnabled(!this.disabled);
    }

    public void setDisabled(String attributeValue) {
        boolean disabled = attributeValue.equals("disabled") || attributeValue.equals("");
        this.setEnabled(!disabled);
    }

    @Override
    public void setForm(Html5FormPanel html5FormPanel) {
        this.form = html5FormPanel;
    }

    @Override
    public void unlock() {
        LockUtils.unlock((Widget)this);
    }

    public void setEnabled(boolean enabled) {
        CommonResourceBundle.INSTANCE.css().ensureInjected();
        boolean bl = this.disabled = !enabled;
        if (this.disabled) {
            this.addStyleName(CommonResourceBundle.INSTANCE.css().disabled());
        } else {
            this.removeStyleName(CommonResourceBundle.INSTANCE.css().disabled());
        }
    }

    public boolean isEnabled() {
        return !this.disabled;
    }
}

