/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms.impl;

import com.calpano.common.client.ClientApp;
import com.calpano.common.client.util.Callback;
import com.calpano.common.client.view.forms.IBelongsToHtml5Form;
import com.calpano.common.client.view.forms.IFormManagingWidget;
import com.calpano.common.client.view.forms.IFormSubmitEventHandler;
import com.calpano.common.client.view.forms.IHtml5EnabledInputWidget;
import com.calpano.common.client.view.forms.impl.Html5SubmitButton;
import com.calpano.common.client.view.forms.locking.ILockable;
import com.calpano.common.client.view.forms.locking.impl.LockUtils;
import com.calpano.common.client.view.forms.utils.FocusUtils;
import com.calpano.common.client.view.forms.validation.HasInvaliationHandlers;
import com.calpano.common.client.view.forms.validation.HasValidationHandlers;
import com.calpano.common.client.view.forms.validation.InvalidationEvent;
import com.calpano.common.client.view.forms.validation.InvalidationHandler;
import com.calpano.common.client.view.forms.validation.ValidationEvent;
import com.calpano.common.client.view.forms.validation.ValidationHandler;
import com.calpano.common.client.view.resources.CommonResourceBundle;
import com.calpano.common.shared.util.CommonAppState;
import com.calpano.common.shared.validation.ValidationMessage;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.List;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;

public class Html5FormPanel
extends FlowPanel
implements Callback,
HasValidationHandlers,
HasInvaliationHandlers,
ILockable {
    private static final Logger log = LoggerFactory.getLogger(Html5FormPanel.class);
    private final List<IFormSubmitEventHandler> formSubmitEventHandlers = new ArrayList<IFormSubmitEventHandler>();
    private IFormManagingWidget formSubmitter = null;
    private boolean isSubmitting;
    private CommonAppState.Is isValid = CommonAppState.Is.Maybe;
    private Html5SubmitButton submitButton = null;
    private final List<IHtml5EnabledInputWidget> textInputs = new ArrayList<IHtml5EnabledInputWidget>(1);
    private final List<HandlerRegistration> validationHandlerRegistrations = new ArrayList<HandlerRegistration>();

    public Html5FormPanel() {
        CommonResourceBundle.INSTANCE.css().ensureInjected();
    }

    public void addFormSubmitEventHandler(IFormSubmitEventHandler formEventHandler) {
        this.formSubmitEventHandlers.add(formEventHandler);
    }

    public void removeFormSubmitEventHandler(IFormSubmitEventHandler formEventHandler) {
        this.formSubmitEventHandlers.remove(formEventHandler);
    }

    private void computeValidation() {
        for (IHtml5EnabledInputWidget h : this.textInputs) {
            ValidationMessage vmsg = h.asHtml5TextInput().computeValidation();
            if (vmsg.level.isValid()) continue;
            this.isValid = CommonAppState.Is.No;
            return;
        }
        this.isValid = CommonAppState.Is.Yes;
    }

    private void findAllChildrenAndAddThem(HasWidgets w) {
        int inputs = 0;
        int submits = 0;
        InputValidationHandler inputValidationHandler = new InputValidationHandler();
        for (Widget child : w) {
            if (child instanceof IBelongsToHtml5Form) {
                IBelongsToHtml5Form html5Submit = (IBelongsToHtml5Form)child;
                html5Submit.setForm(this);
                if (child instanceof IHtml5EnabledInputWidget) {
                    ++inputs;
                    IHtml5EnabledInputWidget h5box = (IHtml5EnabledInputWidget)child;
                    this.textInputs.add(h5box);
                    HandlerRegistration reg = h5box.asHtml5TextInput().addValidationHandler(inputValidationHandler);
                    this.validationHandlerRegistrations.add(reg);
                } else if (child instanceof Html5SubmitButton) {
                    ++submits;
                    assert (this.submitButton == null) : "you have added 2 submit buttons";
                    this.submitButton = (Html5SubmitButton)child;
                }
            }
            if (!(child instanceof HasWidgets)) continue;
            this.findAllChildrenAndAddThem((HasWidgets)child);
        }
        log.trace("Form has " + inputs + " inputs and " + submits + " submits (should be just one");
    }

    private void fireJustBeforeFormSubmit() {
        for (IFormSubmitEventHandler h : this.formSubmitEventHandlers) {
            h.onJustBeforeFormSubmit();
        }
    }

    private void fireOnFormSubmitSuccess() {
        this.unlock();
        for (IFormSubmitEventHandler h : this.formSubmitEventHandlers) {
            h.onFormSubmitSuccess();
        }
    }

    private void fireOnFormSubmitFailed() {
        this.unlock();
        for (IFormSubmitEventHandler h : this.formSubmitEventHandlers) {
            h.onFormSubmitFailed();
        }
    }

    public void init() {
    }

    public boolean isValid() {
        return this.isValid.isTrue();
    }

    @Override
    public void lock() {
        for (IHtml5EnabledInputWidget h5boc : this.textInputs) {
            h5boc.asHtml5TextInput().lock();
        }
        if (this.submitButton != null) {
            this.submitButton.lock();
        }
        LockUtils.lock((Widget)this);
    }

    @Override
    public void onFailure() {
        this.fireOnFormSubmitFailed();
    }

    protected void onLoad() {
        super.onLoad();
        this.findAllChildrenAndAddThem((HasWidgets)this);
        this.addStyleName("form");
        this.init();
    }

    @Override
    public void onSuccess() {
        this.fireOnFormSubmitSuccess();
    }

    protected void onUnload() {
        super.onUnload();
        for (HandlerRegistration reg : this.validationHandlerRegistrations) {
            reg.removeHandler();
        }
        this.validationHandlerRegistrations.clear();
        this.textInputs.clear();
        this.submitButton = null;
    }

    public void reset() {
        this.isValid = CommonAppState.Is.Maybe;
        this.resetLockState();
        for (IHtml5EnabledInputWidget h : this.textInputs) {
            h.asHtml5TextInput().reset();
        }
    }

    @Override
    public void resetLockState() {
        for (IHtml5EnabledInputWidget h5boc : this.textInputs) {
            h5boc.asHtml5TextInput().resetLockState();
        }
        if (this.submitButton != null) {
            this.submitButton.resetLockState();
        }
        this.removeStyleName(CommonResourceBundle.INSTANCE.css().locked());
        this.isSubmitting = false;
    }

    public void setFormSubmitter(IFormManagingWidget formSubmitter) {
        this.formSubmitter = formSubmitter;
    }

    private String stateAsString() {
        return "valid:" + this.isValid + " submitting:" + this.isSubmitting;
    }

    public void tryToSubmit(IBelongsToHtml5Form source) {
        log.info("tryToSubmit state = " + this.stateAsString());
        boolean incomplete = this.formSubmitEventHandlers.size() == 0;
        XyAssert.xyAssert((!incomplete ? 1 : 0) != 0, (Object)"No formEventHandler registered, cannot submit");
        if (!this.isValid.isTrue()) {
            this.computeValidation();
        }
        if (this.isValid.isTrue() && !this.isSubmitting) {
            this.isSubmitting = true;
            log.debug("Submitting form " + this.getElement().getId());
            this.fireJustBeforeFormSubmit();
            this.lock();
            this.formSubmitter.submitForm();
        } else {
            this.showCannotSubmitAndHelpToFix();
        }
    }

    private void showCannotSubmitAndHelpToFix() {
        boolean haveSetFocus = false;
        for (IHtml5EnabledInputWidget h5box : this.textInputs) {
            assert (h5box.asHtml5TextInput().computeValidation() != null) : "should have been computed before";
            if (h5box.asHtml5TextInput().computeValidation().level.isValid()) continue;
            h5box.asHtml5TextInput().activateValidationWarnings();
            log.info("Focussing input element with validation error");
            if (haveSetFocus) continue;
            FocusUtils.setFocus((FocusWidget)h5box.asHtml5TextInput().getTextBoxBase(), true);
            haveSetFocus = true;
        }
    }

    @Override
    public void unlock() {
        for (IHtml5EnabledInputWidget h5boc : this.textInputs) {
            h5boc.asHtml5TextInput().unlock();
        }
        if (this.submitButton != null) {
            this.submitButton.unlock();
        }
        LockUtils.unlock((Widget)this);
        this.isSubmitting = false;
    }

    @Override
    public HandlerRegistration addInvalidationHandler(InvalidationHandler handler) {
        return ClientApp.getEventBus().addHandlerToSource(InvalidationEvent.TYPE, (Object)this, (Object)handler);
    }

    @Override
    public HandlerRegistration addValidationHandler(ValidationHandler handler) {
        return ClientApp.getEventBus().addHandlerToSource(ValidationEvent.TYPE, (Object)this, (Object)handler);
    }

    private class InputValidationHandler
    implements ValidationHandler,
    InvalidationHandler {
        private InputValidationHandler() {
        }

        @Override
        public void onInvalid(InvalidationEvent event) {
            Html5FormPanel.this.isValid = CommonAppState.Is.No;
            if (Html5FormPanel.this.submitButton != null) {
                Html5FormPanel.this.submitButton.setEnabled(false);
            }
        }

        @Override
        public void onValid(ValidationEvent event) {
            Html5FormPanel.this.computeValidation();
            if (Html5FormPanel.this.isValid() && Html5FormPanel.this.submitButton != null) {
                Html5FormPanel.this.submitButton.setEnabled(true);
            }
        }
    }
}

