/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms.impl;

import com.calpano.common.client.view.forms.activation.ActivationEvent;
import com.calpano.common.client.view.forms.activation.ActivationHandler;
import com.calpano.common.client.view.forms.activation.DeactivationEvent;
import com.calpano.common.client.view.forms.activation.DeactivationHandler;
import com.calpano.common.client.view.forms.impl.Html5TextArea;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class AutogrowTextArea
extends Html5TextArea
implements ActivationHandler,
DeactivationHandler {
    private static final Logger log = LoggerFactory.getLogger(AutogrowTextArea.class);
    private String initialHeight;
    private TextArea shadow;
    private int additionalEventsToSink;

    private static void matchStyles(String cssPropertyName, Style source, Style target) {
        String value = source.getProperty(cssPropertyName);
        if (value != null) {
            try {
                target.setProperty(cssPropertyName, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public AutogrowTextArea() {
        this.addActivationHandler(this);
        this.addDeactivationHandler(this);
    }

    public void adjustHeightDeferred() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                AutogrowTextArea.this.adjustHeightNow();
            }
        });
    }

    private void adjustHeightNow() {
        this.shadow.setWidth(this.getElement().getScrollWidth() + 12 + "px");
        this.shadow.setHeight("auto");
        this.shadow.setText(this.getValue());
        this.shadow.setHeight(this.shadow.getElement().getScrollHeight() + 20 + "px");
        this.setHeight(this.shadow.getElement().getScrollHeight() + 18 + "px");
    }

    @Override
    public void onActivation(ActivationEvent event) {
        log.trace("activating autogrow");
        Element element = this.getElement();
        Style thisStyle = element.getStyle();
        this.shadow = new TextArea();
        RootPanel.get().add((Widget)this.shadow);
        thisStyle.setOverflow(Style.Overflow.HIDDEN);
        thisStyle.setProperty("resize", "none");
        this.initialHeight = thisStyle.getProperty("height");
        Style shadowStyle = this.shadow.getElement().getStyle();
        shadowStyle.setPosition(Style.Position.ABSOLUTE);
        shadowStyle.setTop(-9999.0, Style.Unit.PX);
        shadowStyle.setLeft(-9999.0, Style.Unit.PX);
        shadowStyle.setProperty("bottom", "auto");
        shadowStyle.setProperty("right", "auto");
        AutogrowTextArea.matchStyles("display", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("fontFamily", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("fontSize", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("fontStyle", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("fontWeight", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("letterSpacing", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("lineHeight", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("overflow", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("paddingBottom", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("paddingLeft", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("paddingRight", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("paddingTop", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("resize", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("textIndent", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("textTransform", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("width", thisStyle, shadowStyle);
        AutogrowTextArea.matchStyles("wordSpacing", thisStyle, shadowStyle);
        this.sinkEvents(this.additionalEventsToSink);
        this.registerOnCut((com.google.gwt.dom.client.Element)this.getElement());
    }

    @Override
    public void onDeactivation(DeactivationEvent event) {
        this.deregisterOnCut((com.google.gwt.dom.client.Element)this.getElement());
        this.unsinkEvents(this.additionalEventsToSink);
        this.shadow.removeFromParent();
        this.resetHeight();
        this.shadow = null;
    }

    @Override
    public void onBrowserEvent(Event event) {
        if (log.isTraceEnabled()) {
            log.trace("Autogrow event " + event.getType());
        }
        super.onBrowserEvent(event);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        int sunkEvents = super.getSunkEvents();
        int sinkEvents = 529152;
        int reqEvents = 0;
        for (int n = 0; n < 32; ++n) {
            int marker = 1 << n;
            if ((marker & 0x81300) <= 0 || (marker & ~sunkEvents) <= 0) continue;
            reqEvents |= marker;
        }
        this.additionalEventsToSink = reqEvents;
    }

    private native void registerOnCut(com.google.gwt.dom.client.Element var1);

    private native void deregisterOnCut(com.google.gwt.dom.client.Element var1);

    public void resetHeight() {
        if (this.getValue().isEmpty()) {
            this.getElement().getStyle().setProperty("height", this.initialHeight);
        }
    }
}

