/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.crashreport;

import com.calpano.common.client.crashreport.ClientErrorHandlingUtils;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.web.bindery.event.shared.UmbrellaException;
import org.xydra.env.IEnvironment;
import org.xydra.log.api.ILogListener;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.util.SharedExceptionUtils;
import org.xydra.log.util.listener.RememberLogListener;

public class ClientExceptionHandler
implements GWT.UncaughtExceptionHandler {
    private final Logger log;
    private final IEnvironment env;
    public static RememberLogListener rememberLogListener = null;

    public ClientExceptionHandler(IEnvironment env, Logger log, boolean rememberLogs) {
        this.env = env;
        this.log = log;
        if (rememberLogs) {
            rememberLogListener = new RememberLogListener(Logger.Level.Debug);
            LoggerFactory.addLogListener((ILogListener)rememberLogListener);
        }
    }

    public void onUncaughtException(Throwable throwable) {
        String text = "JS exception in Favr: \n" + SharedExceptionUtils.toString((Throwable)throwable);
        this.log.error(text, throwable);
        if (throwable instanceof UmbrellaException) {
            UmbrellaException ue = (UmbrellaException)throwable;
            for (Throwable cause : ue.getCauses()) {
                if (cause.equals(throwable)) {
                    this.log.info("Nested in Umbrella: Same exception as already reported.");
                    continue;
                }
                this.log.error("Additional exception in umbrella: " + cause.getMessage(), cause);
            }
        }
        if (this.env.conf().getBoolean("clientDebugMode")) {
            Window.alert((String)("JS error: " + text.substring(0, Math.min(text.length(), 800)) + " \nCause: " + throwable));
        }
        ClientErrorHandlingUtils.handleError(this.env, text, "unknown", null, rememberLogListener == null ? null : rememberLogListener.getLogs());
    }
}

