/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client;

import com.calpano.common.shared.util.CommonAppState;
import java.util.HashSet;
import java.util.Set;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class AppState
extends CommonAppState {
    private static final Logger log = LoggerFactory.getLogger(AppState.class);
    private static CommonAppState.Process successfulAjax = CommonAppState.Process.Never;
    private static CommonAppState.Process successfulRender = CommonAppState.Process.Never;
    private static boolean authenticatedOnServer_ = false;
    private static Stage currentStage = Stage.Starting;
    private static Set<AppStateListener> listeners = new HashSet<AppStateListener>();
    private static int openAjaxCalls = 0;
    private static int openRenderCalls = 0;

    public static void addListener(AppStateListener listener) {
        listeners.add(listener);
    }

    public static Stage getStage() {
        return currentStage;
    }

    public static boolean isOnline() {
        return successfulAjax == CommonAppState.Process.DoneSuccess;
    }

    public static void printState(String s) {
        log.info("===  " + s + "===");
        log.info("stage=" + (Object)((Object)currentStage));
        log.info("initialRender=" + successfulRender + "\n");
        log.info("initialAjax=" + successfulAjax + "\n");
        log.info("online=" + AppState.isOnline() + "\n");
        log.info("authenticatedOnServer=" + authenticatedOnServer_ + "\n");
        log.info("Open AJAX calls=" + openAjaxCalls + "\n");
        log.info("Open Render calls=" + openRenderCalls + "\n");
    }

    public static boolean isAuthenticatedOnServer() {
        return authenticatedOnServer_;
    }

    public static boolean isWaitingForAjax() {
        return openAjaxCalls > 0 || successfulAjax == CommonAppState.Process.Started;
    }

    public static boolean isWaitingForRendering() {
        return openRenderCalls > 0 || successfulRender == CommonAppState.Process.Started;
    }

    private static void onChange() {
        switch (currentStage) {
            case BeforeScript: {
                throw new AssertionError((Object)"Cannot happen in script-part");
            }
            case Starting: {
                break;
            }
        }
    }

    public static void removeListener(AppStateListener listener) {
        listeners.remove(listener);
    }

    public static void setIsAuthenticatedOnServer(boolean authenticated) {
        authenticatedOnServer_ = authenticated;
        AppState.onChange();
    }

    public static void setStage(Stage stage) {
        assert (currentStage.getNextStages().contains((Object)stage) || stage == currentStage);
        boolean newStage = stage != currentStage;
        currentStage = stage;
        if (newStage) {
            for (AppStateListener l : listeners) {
                l.onAppStateChange();
            }
        }
    }

    public static CommonAppState.Process isSuccessfulRender() {
        return successfulRender;
    }

    public static CommonAppState.Process isSuccessfulAjax() {
        return successfulAjax;
    }

    public static void setStageSilently(Stage stage) {
        currentStage = stage;
    }

    public static int getOpenAjaxCalls() {
        return openAjaxCalls;
    }

    public static int getOpenRenderCalls() {
        return openRenderCalls;
    }

    public static enum Stage {
        BeforeScript(true),
        Starting(true),
        DontShowApp(false),
        Bluescreen(false);

        private final boolean busy;
        Set<Stage> nextStages = new HashSet<Stage>();

        private Stage(boolean busy) {
            this.busy = busy;
        }

        public boolean isBusy() {
            return this.busy;
        }

        public Set<Stage> getNextStages() {
            return this.nextStages;
        }

        public boolean isDeterministic() {
            return this.nextStages.size() < 2;
        }

        public boolean isFinal() {
            return this.nextStages.size() == 0;
        }

        public void setNextStages(Stage ... next) {
            for (Stage s : next) {
                this.nextStages.add(s);
            }
        }

        static {
            BeforeScript.setNextStages(Starting, Bluescreen, DontShowApp);
            Starting.setNextStages(Bluescreen);
            Bluescreen.setNextStages(new Stage[0]);
            DontShowApp.setNextStages(new Stage[0]);
        }
    }

    public static interface AppStateListener {
        public void onAppStateChange();
    }
}

