/*
 * Decompiled with CFR 0.152.
 */
package de.xam.googleanalytics.tracker;

import de.xam.googleanalytics.UrlAndHashUtils;
import de.xam.googleanalytics.tracker.GaUtmbCookie;

public class GaUtmaCookie
extends GaUtmbCookie {
    public long firstVisitStartTime;
    public long lastVisitStartTime;
    public long the31BitId;

    public GaUtmaCookie(String domainName, String domainHash) {
        super(domainName, domainHash);
    }

    public GaUtmaCookie(String cookieString) {
        this.setFromCookieString(cookieString);
    }

    public GaUtmaCookie(String domainName, long the31BitId, long firstVisitStartTime, long lastVisitStartTime, long currentSessionStartTime, long sessionCount) {
        super(domainName, null, currentSessionStartTime, sessionCount);
        this.the31BitId = the31BitId;
        this.firstVisitStartTime = firstVisitStartTime;
        this.lastVisitStartTime = lastVisitStartTime;
    }

    @Override
    public String toCookieString() {
        return this.getDomainHash() + "." + this.the31BitId + "." + this.firstVisitStartTime + "." + this.lastVisitStartTime + "." + this.currentSessionStartTime + "." + this.sessionCount;
    }

    @Override
    public void setFromCookieString(String cookieString) throws IllegalArgumentException {
        String[] dotParts = cookieString.split("\\.");
        if (dotParts.length != 6) {
            throw new IllegalArgumentException("Could not parse '" + cookieString + "' into six dot-separated parts");
        }
        this.domainHash = dotParts[0];
        this.the31BitId = UrlAndHashUtils.parseAsLong(dotParts[1]);
        this.firstVisitStartTime = UrlAndHashUtils.parseAsLong(dotParts[2]);
        this.lastVisitStartTime = UrlAndHashUtils.parseAsLong(dotParts[3]);
        this.currentSessionStartTime = UrlAndHashUtils.parseAsLong(dotParts[4]);
        this.sessionCount = UrlAndHashUtils.parseAsLong(dotParts[5]);
    }

    public long getUniqueId() {
        return this.the31BitId;
    }

    public long getFirstVisit() {
        return this.firstVisitStartTime;
    }
}

