/*
 * Decompiled with CFR 0.152.
 */
package de.xam.googleanalytics.httpclient;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import de.xam.googleanalytics.httpclient.HttpUserAgent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HttpUserAgentUrlFetch
implements HttpUserAgent {
    private final URLFetchService urlfetch;
    private final FetchOptions fetchOptions = FetchOptions.Builder.withDefaults();
    private String userAgent;

    HttpUserAgentUrlFetch() {
        this.urlfetch = URLFetchServiceFactory.getURLFetchService();
    }

    @Override
    public void setAutoRetry(boolean autoRetry) {
    }

    @Override
    public void setConnectionTimeout(int maxMillis) {
        this.fetchOptions.setDeadline(Double.valueOf((double)maxMillis / 1000.0));
    }

    @Override
    public void setUserAgentIdentifier(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public Future<Integer> GET(String urlString) {
        try {
            URL url = new URL(urlString);
            HTTPRequest httpRequest = new HTTPRequest(url);
            if (this.userAgent != null) {
                httpRequest.setHeader(new HTTPHeader("User-Agent", this.userAgent));
            }
            Future result = this.urlfetch.fetchAsync(url);
            return new WrappedFuture(result);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class WrappedFuture
    implements Future<Integer> {
        private final Future<HTTPResponse> future;

        public WrappedFuture(Future<HTTPResponse> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            return this.future.get().getResponseCode();
        }

        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit).getResponseCode();
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }
    }
}

