/*
 * Decompiled with CFR 0.152.
 */
package de.xam.googleanalytics.httpclient;

import de.xam.googleanalytics.httpclient.HttpUserAgent;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class HttpUserAgentApacheCommons
implements HttpUserAgent {
    private static final Logger log = LoggerFactory.getLogger(HttpUserAgentApacheCommons.class);
    private final HttpClient httpClient;
    private final LinkedBlockingQueue<Job> jobQueue;
    private TrackingThread workerThread;
    AtomicInteger attempts = new AtomicInteger();
    AtomicInteger successes = new AtomicInteger();
    AtomicInteger faillures = new AtomicInteger();

    public HttpUserAgentApacheCommons() {
        this.httpClient = new HttpClient();
        this.jobQueue = new LinkedBlockingQueue(1000);
    }

    @Override
    public void setUserAgentIdentifier(String userAgent) {
        System.getProperties().setProperty("httpclient.useragent", userAgent);
    }

    @Override
    public void setConnectionTimeout(int maxMillis) {
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
    }

    @Override
    public void setAutoRetry(boolean autoRetry) {
        this.httpClient.getHttpConnectionManager().getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
    }

    private static boolean isOkStatus(int status) {
        return 200 <= status && status < 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int httpGet(HttpClient httpClient, Job job) {
        log.debug("GET: " + job.url);
        GetMethod get = new GetMethod(job.url);
        try {
            int status;
            job.status = status = httpClient.executeMethod((HttpMethod)get);
            if (HttpUserAgentApacheCommons.isOkStatus(status)) {
                log.trace("Status " + status);
            } else {
                log.debug("Status code is " + status);
            }
            int n = status;
            return n;
        }
        catch (IOException e) {
            log.info("Network error. Could not track " + job.url);
            log.debug("Network error = ", (Throwable)e);
            int n = 404;
            return n;
        }
        finally {
            get.releaseConnection();
        }
    }

    private static final long toMillis(long time, TimeUnit unit) {
        long result = time;
        switch (unit) {
            case NANOSECONDS: {
                return result / 1000000L;
            }
            case MICROSECONDS: {
                return result / 1000L;
            }
            case MILLISECONDS: {
                return result;
            }
            case SECONDS: {
                return result * 1000L;
            }
            case MINUTES: {
                return result * 1000L * 60L;
            }
            case HOURS: {
                return result * 1000L * 60L * 60L;
            }
            case DAYS: {
                return result * 1000L * 60L * 60L * 24L;
            }
        }
        throw new AssertionError();
    }

    @Override
    public synchronized Future<Integer> GET(String url) {
        Job job = new Job(url);
        boolean scheduled = this.jobQueue.offer(job);
        if (!scheduled) {
            log.warn("More than 1000 urls scheduled for tracking.");
        }
        if (this.workerThread == null) {
            this.workerThread = new TrackingThread();
            this.workerThread.start();
        }
        return job;
    }

    private static class Job
    implements Future<Integer> {
        public int status = -1;
        String url;
        private boolean cancelled = false;
        private final boolean done = false;

        public Job(String url) {
            this.url = url;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.getClass();
            if (this.cancelled) {
                return false;
            }
            this.cancelled = true;
            return true;
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            while (!this.isDone() && !this.isCancelled() && this.status < 0) {
                Thread.sleep(1000L);
            }
            return this.status;
        }

        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            while (!this.isDone() && !this.isCancelled() && this.status < 0) {
                Thread.sleep(HttpUserAgentApacheCommons.toMillis(timeout, unit));
            }
            return null;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }

    private class TrackingThread
    extends Thread {
        private boolean shouldRun;

        public TrackingThread() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            HttpUserAgentApacheCommons.this.attempts.incrementAndGet();
            this.shouldRun = true;
            this.giveUpOnBadNetwork();
            while (this.shouldRun) {
                try {
                    Job job = (Job)HttpUserAgentApacheCommons.this.jobQueue.take();
                    int status = HttpUserAgentApacheCommons.httpGet(HttpUserAgentApacheCommons.this.httpClient, job);
                    while (!HttpUserAgentApacheCommons.isOkStatus(status) && this.shouldRun) {
                        log.warn("HTTP GET failed, retry in 20 seconds");
                        HttpUserAgentApacheCommons.this.faillures.incrementAndGet();
                        Thread.sleep(20000L);
                        status = HttpUserAgentApacheCommons.httpGet(HttpUserAgentApacheCommons.this.httpClient, job);
                        this.giveUpOnBadNetwork();
                    }
                    HttpUserAgentApacheCommons.this.successes.incrementAndGet();
                }
                catch (InterruptedException e) {
                    log.debug("waiting for urls to track", (Throwable)e);
                }
            }
        }

        private void giveUpOnBadNetwork() {
            if (HttpUserAgentApacheCommons.this.successes.get() == 0 && HttpUserAgentApacheCommons.this.faillures.get() >= 3 && HttpUserAgentApacheCommons.this.attempts.get() < 50) {
                this.shouldRun = false;
                log.warn("So many HTTP errors, not even trying to GET");
            } else {
                log.info("HTTP STATUS: " + HttpUserAgentApacheCommons.this.attempts.get() + " attempts: " + HttpUserAgentApacheCommons.this.successes.get() + " succ with " + HttpUserAgentApacheCommons.this.faillures.get() + " fail ");
            }
        }
    }
}

