/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.memcache.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xydra.base.minio.MiniIOException;
import org.xydra.base.minio.MiniStreamWriter;
import org.xydra.base.minio.MiniWriter;
import org.xydra.perf.MapStats;
import org.xydra.sharedutils.XyAssert;
import org.xydra.xgae.memcache.api.IMemCache;
import org.xydra.xgae.memcache.impl.LocalMemcache;

public class StatsGatheringMemCacheWrapper
implements IMemCache {
    private final MapStats mapstats = new MapStats();
    private final Map<String, Long> stats = new HashMap<String, Long>();
    public static StatsGatheringMemCacheWrapper INSTANCE;
    private final IMemCache base;

    public StatsGatheringMemCacheWrapper(IMemCache memcache) {
        this.base = memcache;
        INSTANCE = this;
    }

    public int size() {
        return this.base.size();
    }

    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    public boolean containsKey(Object key) {
        XyAssert.xyAssert((boolean)(key instanceof String));
        this.count("containsKey");
        return this.base.containsKey(key instanceof String ? key : key.toString());
    }

    private void count(String action) {
        Long l = this.stats.get(action);
        if (l == null) {
            this.stats.put(action, 1L);
        } else {
            this.stats.put(action, l + 1L);
        }
    }

    public boolean containsValue(Object value) {
        this.count("containsValue");
        return this.base.containsValue(value);
    }

    public Object get(Object key) {
        XyAssert.xyAssert((boolean)(key instanceof String));
        this.count("get");
        String usedKey = key instanceof String ? (String)key : key.toString();
        Object value = this.base.get((Object)usedKey);
        this.mapstats.recordGet(key.toString(), value != null, 1);
        return value;
    }

    public Map<String, Object> getAll(Collection<String> keys) {
        this.count("getAll");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : keys) {
            Object value = this.base.get((Object)key);
            this.mapstats.recordGet(key.toString(), value != null, keys.size());
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public Object put(String key, Object value) {
        this.count("put");
        this.mapstats.recordPut(key.toString(), value);
        return this.base.put((Object)key, value);
    }

    public void putIfValueIsNull(String key, Object value) {
        this.count("putIfValueIsNull");
        this.mapstats.recordPut(key.toString(), value);
        this.base.putIfValueIsNull(key, value);
    }

    public Object remove(Object key) {
        this.count("remove");
        return this.base.remove(key);
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        this.count("putAll");
        this.base.putAll(m);
    }

    public void clear() {
        this.count("clear");
        this.base.clear();
        this.stats.clear();
        this.mapstats.clear();
    }

    public Set<String> keySet() {
        this.count("keySet");
        return this.base.keySet();
    }

    public Collection<Object> values() {
        this.count("values");
        return this.base.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.count("entrySet");
        return this.base.entrySet();
    }

    public boolean equals(Object o) {
        return this.base.equals(o);
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public String stats() {
        StringBuffer buf = new StringBuffer();
        for (String s : this.stats.keySet()) {
            buf.append(s + " = " + this.stats.get(s) + "<br />\n");
        }
        buf.append("Access stats ===================================================== <br />\n");
        try {
            StringWriter sw = new StringWriter();
            this.mapstats.writeStats((MiniWriter)new MiniStreamWriter((Writer)sw));
            buf.append(sw.toString());
        }
        catch (MiniIOException e) {
            throw new RuntimeException(e);
        }
        buf.append("BASE stats<br />\n");
        buf.append(this.base.stats() + "<br />\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfUntouched(String key, IMemCache.IdentifiableValue oldValue, Object newValue) {
        this.count("putIfUntouched");
        IMemCache iMemCache = this.base;
        synchronized (iMemCache) {
            Object current = this.get(key);
            if (current.equals(oldValue.getValue())) {
                this.put(key, newValue);
                return true;
            }
            return false;
        }
    }

    public IMemCache.IdentifiableValue getIdentifiable(String key) {
        Object o = this.get(key);
        return new LocalMemcache.IdentifiableImpl(o);
    }

    public Map<String, Long> incrementAll(Map<String, Long> offsets, long initialValue) {
        this.count("incrementAll");
        Map<String, Long> result = new HashMap();
        result = this.base.incrementAll(offsets, initialValue);
        for (Map.Entry entry : result.entrySet()) {
            this.mapstats.recordPut((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Object putChecked(String key, Object value) throws IOException {
        return this.put(key, value);
    }
}

