/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.gaeutils;

import com.google.appengine.api.capabilities.CapabilitiesService;
import com.google.appengine.api.capabilities.CapabilitiesServiceFactory;
import com.google.appengine.api.capabilities.Capability;
import com.google.appengine.api.capabilities.CapabilityStatus;
import com.google.appengine.api.utils.SystemProperty;
import com.google.apphosting.api.ApiProxy;
import org.xydra.store.XydraRuntime;

public class AboutAppEngine {
    public static boolean inProduction() {
        return SystemProperty.environment.get() != null && SystemProperty.environment.value().equals((Object)SystemProperty.Environment.Value.Production);
    }

    public static boolean inDevelopment() {
        return SystemProperty.environment.get() != null && SystemProperty.environment.value().equals((Object)SystemProperty.Environment.Value.Development);
    }

    public static boolean onAppEngine() {
        return AboutAppEngine.inProduction() || AboutAppEngine.inDevelopment();
    }

    public static boolean notOnAppengine() {
        return !AboutAppEngine.onAppEngine();
    }

    public static String getVersion() {
        String version = SystemProperty.applicationVersion.get();
        if (version == null) {
            version = "devmode";
        }
        return version;
    }

    public static String getInstanceId() {
        return "GAE:" + SystemProperty.instanceReplicaId.get() + ";Xydra:" + XydraRuntime.getInstanceId();
    }

    public static String getThreadInfo() {
        Thread ct = Thread.currentThread();
        return ct.getId() + "-'" + ct.getName() + "'";
    }

    public static String getApplicationId() {
        String id = SystemProperty.applicationId.get();
        if (id == null) {
            id = "devmode";
        }
        return id;
    }

    public static boolean canWriteDataStore() {
        CapabilitiesService service = CapabilitiesServiceFactory.getCapabilitiesService();
        CapabilityStatus status = service.getStatus(Capability.DATASTORE_WRITE).getStatus();
        return status == CapabilityStatus.ENABLED;
    }

    public static String inModeAsString() {
        return (AboutAppEngine.inProduction() ? "inProduction" : "inDevelopment") + "-" + (AboutAppEngine.onAppEngine() ? "onAppEngine" : "notOnAppEngine") + "-" + "module:" + ApiProxy.getCurrentEnvironment().getModuleId();
    }
}

