/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.datastore.impl.gae;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import java.util.Iterator;
import java.util.List;
import org.xydra.index.TransformerTool;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.TransformingIterator;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.SPreparedQuery;
import org.xydra.xgae.datastore.impl.gae.GEntity;
import org.xydra.xgae.datastore.impl.gae.GKey;
import org.xydra.xgae.datastore.impl.gae.RawWrapper;

public class GPreparedQuery
extends RawWrapper<PreparedQuery, SPreparedQuery>
implements SPreparedQuery,
Iterable<SEntity> {
    private int limit;
    private int chunkSize;

    private GPreparedQuery(PreparedQuery raw) {
        super(raw);
    }

    public static GPreparedQuery wrap(PreparedQuery raw) {
        if (raw == null) {
            return null;
        }
        return new GPreparedQuery(raw);
    }

    public Iterable<SEntity> asIterable() {
        return this;
    }

    @Deprecated
    public List<SEntity> asListWithChunkSize(int chunkSize) {
        this.setChunkSize(chunkSize);
        return this.asList();
    }

    @Override
    public Iterator<SEntity> iterator() {
        return new TransformingIterator(((PreparedQuery)this.raw()).asIterator(), (ITransformer)new ITransformer<Entity, SEntity>(){

            public SEntity transform(Entity in) {
                return GEntity.wrap(in);
            }
        });
    }

    public Iterable<SKey> asKeysIterable() throws IllegalArgumentException {
        return new KeyIterable();
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    private FetchOptions toFetchOptions() {
        FetchOptions fo = FetchOptions.Builder.withDefaults();
        if (this.limit > 0) {
            fo.limit(this.limit);
        }
        if (this.chunkSize > 0) {
            fo.chunkSize(this.chunkSize);
        }
        return fo;
    }

    public List<SEntity> asList() {
        List rawList = ((PreparedQuery)this.raw()).asList(this.toFetchOptions());
        return TransformerTool.transformListEntries((List)rawList, GEntity.TRANSFOMER_ENTITY_SENTITY);
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    private class KeyIterable
    implements Iterable<SKey> {
        private KeyIterable() {
        }

        @Override
        public Iterator<SKey> iterator() {
            return new TransformingIterator(((PreparedQuery)GPreparedQuery.this.raw()).asIterator(), (ITransformer)new ITransformer<Entity, SKey>(){

                public SKey transform(Entity in) {
                    return GKey.wrap(in.getKey());
                }
            });
        }
    }
}

