/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.datastore.impl.gae;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.xgae.datastore.api.IDatastoreSync;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.SPreparedQuery;
import org.xydra.xgae.datastore.api.STransaction;
import org.xydra.xgae.datastore.impl.gae.DatastoreImplGaeBase;
import org.xydra.xgae.datastore.impl.gae.GEntity;
import org.xydra.xgae.datastore.impl.gae.GKey;
import org.xydra.xgae.datastore.impl.gae.GMaps;
import org.xydra.xgae.datastore.impl.gae.GPreparedQuery;
import org.xydra.xgae.datastore.impl.gae.GTransaction;
import org.xydra.xgae.gaeutils.GaeTestfixer;
import org.xydra.xgae.util.XGaeDebugHelper;

public class DatastoreImplGaeSync
extends DatastoreImplGaeBase
implements IDatastoreSync {
    private final Logger log = LoggerFactory.getLogger(DatastoreImplGaeSync.class);
    private DatastoreService syncDatastore;
    public static final String DATASTORE_NAME = "[#DSs]";

    public DatastoreImplGaeSync() {
        GaeTestfixer.enable();
        GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
    }

    public SEntity getEntity(SKey key) {
        return this.getEntity(key, null);
    }

    private void makeSureDatestoreServiceIsInitialised() {
        GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        if (this.syncDatastore == null) {
            this.log.debug(XGaeDebugHelper.init((String)DATASTORE_NAME));
            DatastoreServiceConfig config = DatastoreServiceConfig.Builder.withImplicitTransactionManagementPolicy((ImplicitTransactionManagementPolicy)ImplicitTransactionManagementPolicy.NONE).maxEntityGroupsPerRpc(1);
            this.syncDatastore = DatastoreServiceFactory.getDatastoreService((DatastoreServiceConfig)config);
        }
    }

    public void putEntity(SEntity entity) {
        this.putEntity(entity, null);
    }

    public void putEntitiesInCrossGroupTransaction(GEntity ... entities) {
        this.log.debug("-- begin XG Transaction --");
        this.makeSureDatestoreServiceIsInitialised();
        XyAssert.xyAssert((entities.length >= 2 ? 1 : 0) != 0);
        XyAssert.xyAssert((entities.length <= 5 ? 1 : 0) != 0);
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        TransactionOptions options = TransactionOptions.Builder.withXG((boolean)true);
        Transaction txn = datastore.beginTransaction(options);
        for (GEntity e : entities) {
            datastore.put(txn, (Entity)e.raw());
        }
        txn.commit();
    }

    public void putEntity(SEntity entity, STransaction txn) {
        XyAssert.xyAssert((entity != null ? 1 : 0) != 0, (Object)"entity is null");
        assert (entity != null);
        this.log.debug(XGaeDebugHelper.dataPut((String)DATASTORE_NAME, (String)XGaeDebugHelper.toString((SKey)entity.getKey()), (Object)entity, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        this.makeSureDatestoreServiceIsInitialised();
        assert (this.syncDatastore != null);
        this.syncDatastore.put(txn == null ? null : (Transaction)txn.raw(), (Entity)entity.raw());
    }

    public void putEntities(Iterable<SEntity> it) {
        XyAssert.xyAssert((it != null ? 1 : 0) != 0, (Object)"iterable is null");
        assert (it != null);
        this.log.debug(XGaeDebugHelper.dataPut((String)DATASTORE_NAME, (String)"entities", (Object)"many", (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        this.makeSureDatestoreServiceIsInitialised();
        this.syncDatastore.put(GEntity.unwrap(it));
    }

    public STransaction beginTransaction() {
        this.log.debug("-- begin Transaction --");
        this.makeSureDatestoreServiceIsInitialised();
        return GTransaction.wrap(this.syncDatastore.beginTransaction());
    }

    public void endTransaction(STransaction txn) throws ConcurrentModificationException {
        this.log.debug("-- end Transaction --");
        this.makeSureDatestoreServiceIsInitialised();
        ((Transaction)txn.raw()).commit();
    }

    public void deleteEntity(SKey key) {
        this.deleteEntity(key, null);
    }

    public void deleteEntity(SKey key, STransaction txn) {
        assert (key != null);
        this.log.debug(XGaeDebugHelper.dataPut((String)DATASTORE_NAME, (String)key.toString(), null, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        this.makeSureDatestoreServiceIsInitialised();
        this.syncDatastore.delete(txn == null ? null : (Transaction)txn.raw(), new Key[]{(Key)key.raw()});
    }

    public void deleteEntities(Iterable<SKey> it) {
        assert (it != null);
        if (this.log.isDebugEnabled()) {
            HashMap<Key, Object> map = new HashMap<Key, Object>();
            for (SKey k : it) {
                map.put((Key)k.raw(), null);
            }
            this.log.debug(XGaeDebugHelper.dataPut((String)DATASTORE_NAME, map, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        }
        this.makeSureDatestoreServiceIsInitialised();
        this.syncDatastore.delete(GKey.unwrap(it));
    }

    public boolean isTransactionsActive() {
        return !this.syncDatastore.getActiveTransactions().isEmpty();
    }

    public void clear() {
        this.log.info("Datastore clear");
        this.makeSureDatestoreServiceIsInitialised();
        this.deleteAllDataOnLiveDatastore();
        this.deleteAllEntitiesOneByOne();
    }

    public void deleteAllEntitiesOneByOne() {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Query mydeleteq = new Query();
        PreparedQuery pq = datastore.prepare(mydeleteq);
        for (Entity result : pq.asIterable()) {
            datastore.delete(new Key[]{result.getKey()});
        }
    }

    private void deleteAllDataOnLiveDatastore() {
        List<String> kinds = this.getAllKinds();
        for (String kind : kinds) {
            LinkedList<Key> keys = new LinkedList<Key>();
            Query q = new Query(kind).setKeysOnly();
            PreparedQuery pq = this.syncDatastore.prepare(q);
            for (Entity entity : pq.asIterable()) {
                keys.add(entity.getKey());
            }
            try {
                this.syncDatastore.delete(keys);
            }
            catch (Exception e) {
                this.log.warn("Could not delete kind '" + kind + "'", (Throwable)e);
            }
        }
    }

    public List<String> getAllKinds() {
        this.makeSureDatestoreServiceIsInitialised();
        LinkedList<String> kinds = new LinkedList<String>();
        Iterable statKinds = this.syncDatastore.prepare(new Query("__Stat_Kind__")).asIterable();
        for (Entity statKind : statKinds) {
            String kind = statKind.getProperty("kind_name").toString();
            if (kind.startsWith("__")) continue;
            kinds.add(kind);
        }
        return kinds;
    }

    public Map<SKey, SEntity> getEntities(Collection<SKey> keys, STransaction txn) {
        assert (keys != null);
        this.makeSureDatestoreServiceIsInitialised();
        Map result = keys.isEmpty() ? Collections.emptyMap() : this.syncDatastore.get(txn == null ? null : (Transaction)txn.raw(), GKey.unwrap(keys));
        this.log.debug(XGaeDebugHelper.dataGet((String)DATASTORE_NAME, keys, result, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        return GMaps.wrap(result);
    }

    public Map<SKey, SEntity> getEntities(Collection<SKey> keys) {
        return this.getEntities(keys, null);
    }

    public GEntity getEntity(SKey key, STransaction txn) {
        Entity e;
        assert (key != null);
        this.makeSureDatestoreServiceIsInitialised();
        try {
            e = this.syncDatastore.get(txn == null ? null : (Transaction)txn.raw(), (Key)key.raw());
        }
        catch (EntityNotFoundException e1) {
            e = null;
        }
        this.log.debug(XGaeDebugHelper.dataGet((String)DATASTORE_NAME, (String)XGaeDebugHelper.toString((SKey)key), (Object)e, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        return GEntity.wrap(e);
    }

    public SPreparedQuery prepareRangeQuery(String kind, boolean keysOnly, String lowName, String highName) {
        return this.prepareRangeQuery(kind, keysOnly, lowName, highName, null);
    }

    public SPreparedQuery prepareRangeQuery(String kind, boolean keysOnly, String lowName, String highName, STransaction txn) {
        this.makeSureDatestoreServiceIsInitialised();
        Query query = this.createRangeQuery(kind, keysOnly, lowName, highName);
        assert (query != null);
        assert (this.syncDatastore != null);
        return GPreparedQuery.wrap(this.syncDatastore.prepare(txn == null ? null : (Transaction)txn.raw(), query));
    }

    public String getDatastoreName() {
        return DATASTORE_NAME;
    }
}

