/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.index;

import com.google.common.collect.Sets;
import de.xam.itemset.index.IItemSetManagedIndex;
import de.xam.itemset.index.IndexManager;
import org.xydra.base.XId;

public class IndexState {
    private final IndexManager indexManager;
    private final XId id;
    private boolean isComputed = false;
    private boolean isUpdating = false;
    private final String label;
    private final IItemSetManagedIndex managedIndex;

    public IndexState(IndexManager indexManager, XId id, String label, IItemSetManagedIndex managedIndex) {
        this.indexManager = indexManager;
        this.id = id;
        this.label = label;
        this.managedIndex = managedIndex;
    }

    public XId getId() {
        return this.id;
    }

    public void markAsDirty() {
        this.isComputed = false;
    }

    public void markAsComputed() {
        this.isComputed = true;
    }

    public String getLabel() {
        return this.label;
    }

    public IItemSetManagedIndex getManagedIndex() {
        return this.managedIndex;
    }

    public boolean isComputed() {
        return this.isComputed;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    void setUpdating(boolean b) {
        this.isUpdating = b;
    }

    public void forceReCompute(IndexManager.IIndexProgress indexProgress) {
        this.markAsDirty();
        this.ensureIsComputed(indexProgress);
    }

    public boolean ensureIsComputed(IndexManager.IIndexProgress indexProgress) {
        if (this.isComputed()) {
            return false;
        }
        return this.indexManager.reCompute(Sets.newHashSet((Object[])new IndexState[]{this}), indexProgress);
    }

    public boolean assertIs_computed_updating(Boolean computed, Boolean updating) {
        this.assert_(computed, this.isComputed(), "isComputed");
        this.assert_(updating, this.isUpdating(), "isUpdating");
        return true;
    }

    void assert_(Boolean desired, boolean actual, String msg) {
        boolean a;
        boolean bl = a = desired == null || desired == actual;
        if (!a) {
            throw new IllegalStateException("Index '" + this.getLabel() + "'[" + this.getId() + "] " + msg + " Expected:" + desired + " but was " + actual);
        }
    }

    public String toString() {
        return this.id + ".computed=" + this.isComputed + ",updating=" + this.isUpdating;
    }
}

