/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.xam.cds.CdsId;
import de.xam.cds.CdsIdT;
import de.xam.cmodel.CVocabularies;
import de.xam.vocabulary.Vocabularies;
import de.xam.vocabulary.Vocabulary;
import de.xam.vocabulary.VocabularyTerm;
import org.xydra.base.XId;

public class CDS {
    private static boolean initDone = false;
    private static BiMap<CdsId, XId> idMapping = HashBiMap.create((int)CdsId.values().length);
    public static final Vocabulary _VOC = Vocabularies.create((String)"cds", CDS.class);
    public static final CdsIdT.IIdMapper<XId> ID_MAPPER = new CdsIdT.IIdMapper<XId>(){

        public XId toId(CdsId cdsId) {
            CDS.init();
            return CDS.getXId(cdsId);
        }
    };
    public static final CdsIdT<XId> INSTANCE = new CdsIdT(ID_MAPPER);

    private static synchronized void init() {
        if (initDone) {
            return;
        }
        for (CdsId cdsId : CdsId.values()) {
            VocabularyTerm vt;
            if (cdsId.isRelation()) {
                vt = CVocabularies.createRelation((Vocabulary)_VOC, (String)cdsId.name());
            } else {
                assert (cdsId.isItem());
                vt = CVocabularies.createItem((Vocabulary)_VOC, (String)cdsId.name());
            }
            XId id = vt.setLabel(cdsId.getLabel()).id();
            idMapping.put((Object)cdsId, (Object)id);
        }
        initDone = true;
    }

    public static CdsId getCdsId(XId xid) {
        CDS.init();
        return (CdsId)idMapping.inverse().get((Object)xid);
    }

    public static XId getXId(CdsId cdsId) {
        CDS.init();
        return (XId)idMapping.get((Object)cdsId);
    }

    public static void main(String[] args) {
        CdsId[] ids;
        Vocabulary _VOC = Vocabularies.create((String)"cds", CDS.class);
        for (CdsId id : ids = new CdsId[]{CdsId.type_relation, CdsId.type_symmetricRelation, CdsId.type_transitiveRelation}) {
            VocabularyTerm vt = CVocabularies.createRelation((Vocabulary)_VOC, (String)id.name());
            System.out.println(vt.id());
            System.out.println("==>");
            VocabularyTerm vt2 = CVocabularies.createItem((Vocabulary)_VOC, (String)id.name());
            System.out.println(vt2.id());
        }
    }
}

