/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset;

import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.util.XydraUtils;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import java.util.Iterator;
import org.xydra.base.XId;
import org.xydra.base.value.XBooleanValue;
import org.xydra.base.value.XLongListValue;
import org.xydra.base.value.XStringValue;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;

public class Attributes {
    public static boolean getBooleanAttribute(IEntity item, XId attributeId) {
        XValue value = item.getAttribute(attributeId);
        if (value == null) {
            return false;
        }
        if (value instanceof XStringValue) {
            Boolean b = Boolean.parseBoolean(value.toString());
            return b;
        }
        return ((XBooleanValue)value).contents();
    }

    public static byte[] getByteArrayAttribute(IEntity item, XId attributeId) {
        XValue value = item.getAttribute(attributeId);
        return XydraUtils.toByteArray((XValue)value);
    }

    public static int getIntAttribute(IEntity item, XId attributeId) throws IllegalStateException {
        XValue value = item.getAttribute(attributeId);
        return XydraUtils.toInt((XValue)value);
    }

    public static long getLongAttribute(IEntity item, XId attributeId) {
        XValue value = item.getAttribute(attributeId);
        return XydraUtils.toLongIfPossible((XValue)value);
    }

    public static String getStringAttribute(IEntity item, XId attributeId) {
        XValue value = item.getAttribute(attributeId);
        return XydraUtils.toString((XValue)value);
    }

    public static void renameIfTargetDoesntExist(IEntity entity, XId sourceId, XId targetId) {
        if (entity.getAttribute(targetId) == null) {
            XValue sourceValue = entity.getAttribute(sourceId);
            entity.setAttribute(targetId, sourceValue);
        }
        entity.setAttribute(sourceId, null);
    }

    public static boolean setAttribute(IItemSet itemSet, XId itemId, XId attributeId, XValue value, IChangeData changeData) {
        IItem item = itemSet.getOrCreateAndAddItem(itemId, changeData);
        return item.setAttribute(attributeId, value);
    }

    public static void setBooleanAttribute(IEntity entity, XId attributeId, boolean value) {
        entity.setAttribute(attributeId, (XValue)XV.toValue((boolean)value));
    }

    public static void setStringAttribute(IEntity entity, XId attributeId, String value) {
        entity.setAttribute(attributeId, (XValue)XV.toValue((String)value));
    }

    public static void appendLongToLongListAttribute(IEntity item, XId attributeId, long longValue) {
        XLongListValue newValue;
        XValue oldValue = item.getAttribute(attributeId);
        if (oldValue == null) {
            newValue = XV.toValue((long[])new long[]{longValue});
        } else if (oldValue instanceof XLongListValue) {
            newValue = ((XLongListValue)oldValue).add(Long.valueOf(longValue));
        } else if (oldValue instanceof XStringValue) {
            String s = ((XStringValue)oldValue).contents();
            String newString = s + "," + longValue;
            long[] longs = XydraUtils.toLongArray((String)newString);
            newValue = XV.toValue((long[])longs);
        } else {
            throw new IllegalStateException("content is a " + oldValue.getType() + " - cannot convert to long");
        }
        item.setAttribute(attributeId, (XValue)newValue);
    }

    public static long[] getLongListAttribute(IEntity item, XId attributeId) {
        XValue value = item.getAttribute(attributeId);
        return XydraUtils.toLongArrayIfPossible((XValue)value);
    }

    public static void copyAttributes(IEntity a, IEntity b) {
        Iterator it = a.attributes();
        while (it.hasNext()) {
            XId attIt = (XId)it.next();
            XValue attValue = a.getAttribute(attIt);
            b.setAttribute(attIt, attValue);
        }
    }
}

