/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_1_0.write;

import com.calpano.kgif.util.HumanReadableText;
import com.calpano.kgif.v1_1_0.KgifIO;
import com.calpano.kgif.v1_1_0.gen.Attribute;
import com.calpano.kgif.v1_1_0.gen.Attributes;
import com.calpano.kgif.v1_1_0.gen.Header;
import com.calpano.kgif.v1_1_0.gen.Kgif;
import com.calpano.kgif.v1_1_0.gen.Label;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.gen.Property;
import com.calpano.kgif.v1_1_0.ioutils.KgifDump;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.bind.JAXBException;

public class KgifWrites {
    public static final String XSD = "http://xam.de/ns/kgif/v1.1.0/kgif_v1_1_0.xsd";
    public static final String VERSION_DATE = "2015-04-16";
    public static final String VERSION_NUMBER = "1.1.0";

    public static void appendToMetadata(Metadata metadata, String key, String value) {
        assert (metadata != null);
        Attribute attribute = new Attribute();
        attribute.setName(key);
        attribute.setContent(value);
        Attributes atts = metadata.getAttributes();
        if (atts == null) {
            atts = new Attributes();
            metadata.setAttributes(atts);
        }
        atts.getAttribute().add(attribute);
    }

    public static Header createHeader(String toolName, String toolVersionNumber, String fileCreationDate) {
        Header header = new Header();
        header.setToolVersionNumber(toolVersionNumber);
        header.setToolName(toolName);
        header.setFileCreated(fileCreationDate);
        header.setFileLastModified(HumanReadableText.fullDateTimeIso(System.currentTimeMillis()));
        return header;
    }

    public static Link createLink(Node node1, Node node2, Node node3) {
        Link link = new Link();
        link.setFrom(node1.getId());
        link.setType(node2.getId());
        link.setTo(node3.getId());
        return link;
    }

    public static Link createLink(String from, String type, String to) {
        Link link = new Link();
        link.setFrom(from);
        link.setType(type);
        link.setTo(to);
        return link;
    }

    public static Metadata createMetadata(String key, String value) {
        Metadata metadata = new Metadata();
        KgifWrites.appendToMetadata(metadata, key, value);
        return metadata;
    }

    public static Node createNode(String id, String label) {
        Node node = new Node();
        node.setId(id);
        if (label != null) {
            Label label1 = new Label();
            label1.setContentType("http://www.w3.org/2001/XMLSchema#string");
            label1.setContent(label);
            node.setLabel(label1);
        }
        return node;
    }

    public static Node createNode(String id, String labelStr, String labelContentType) {
        Node node = new Node();
        node.setId(id);
        Label label1 = new Label();
        label1.setContentType(labelContentType);
        label1.setContent(labelStr);
        node.setLabel(label1);
        return node;
    }

    public static void main(String[] args) throws IOException, JAXBException {
        File f = new File("src/main/resources/kgif_v1_1_0_sample.xml");
        File f2 = new File("/Users/xamde/Denkwerkzeug Knowledge Files/aaaa/kgif.xml");
        FileInputStream fis = new FileInputStream(f2);
        InputStreamReader r = new InputStreamReader((InputStream)fis, "UTF-8");
        Kgif kgif = KgifIO.readToDocument(r);
        KgifDump.dump(kgif);
    }

    public static void setMetadataAttribute(Property property, String key, String value) {
        Metadata metadata = property.getMetadata();
        if (metadata == null) {
            metadata = new Metadata();
            property.setMetadata(metadata);
        }
        KgifWrites.setMetadataAttribute(metadata, key, value);
    }

    public static void setMetadataAttribute(Link link, String key, String value) {
        Metadata metadata = link.getMetadata();
        if (metadata == null) {
            metadata = new Metadata();
            link.setMetadata(metadata);
        }
        KgifWrites.setMetadataAttribute(metadata, key, value);
    }

    public static void setMetadataAttribute(Node node, String key, String value) {
        Metadata metadata = node.getMetadata();
        if (metadata == null) {
            metadata = new Metadata();
            node.setMetadata(metadata);
        }
        KgifWrites.setMetadataAttribute(metadata, key, value);
    }

    private static void setMetadataAttribute(Metadata metadata, String key, String value) {
        Attributes atts = metadata.getAttributes();
        if (atts == null) {
            atts = new Attributes();
            metadata.setAttributes(atts);
        }
        for (Attribute attribute : atts.getAttribute()) {
            if (!attribute.getName().equals(key)) continue;
            if (value == null) {
                atts.getAttribute().remove(attribute);
                break;
            }
            attribute.setContent(value);
            break;
        }
        if (value != null) {
            Attribute att = new Attribute();
            att.setName(key);
            att.setContent(value);
            atts.getAttribute().add(att);
        }
    }
}

