/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.util;

import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class XmlReaderTools {
    private static final Logger log = LoggerFactory.getLogger(XmlReaderTools.class);

    public static boolean isAnExpectedEventType(XMLStreamReader xmlreader, int eventType, int[] expectedEvents) {
        for (int i = 0; i < expectedEvents.length; ++i) {
            int expectedEvent = expectedEvents[i];
            if (eventType == 8) {
                throw new RuntimeException("Sudden end of docuemnt while waiting for eventType=" + eventType);
            }
            if (eventType != expectedEvent) continue;
            return true;
        }
        return false;
    }

    public static boolean isExpected(XMLStreamReader xmlreader, String ... expectedElementNames) {
        assert (xmlreader.getEventType() == 1 || xmlreader.getEventType() == 2) : "EventType = " + xmlreader.getEventType();
        String currentElementName = xmlreader.getLocalName();
        for (String expectedElementName : expectedElementNames) {
            if (!expectedElementName.equals(currentElementName)) continue;
            return true;
        }
        return false;
    }

    public static void skipEvents(XMLStreamReader xmlreader, int ... tabooEvents) throws XMLStreamException {
        int eventType = xmlreader.getEventType();
        for (int i = 0; i < tabooEvents.length; ++i) {
            if (eventType != tabooEvents[i]) continue;
            eventType = xmlreader.next();
        }
    }

    public static void skipUntilElementEnd(XMLStreamReader xmlreader, String ... expectedElementNames) throws XMLStreamException {
        boolean found = false;
        do {
            XmlReaderTools.skipUntilEvent(xmlreader, 2);
            found = XmlReaderTools.isExpected(xmlreader, expectedElementNames);
            if (found) continue;
            log.info("Skipped '" + xmlreader.getLocalName() + "' and waiting for " + Arrays.toString(expectedElementNames));
            xmlreader.next();
        } while (!found);
    }

    public static boolean skipUntilElementStart(XMLStreamReader xmlreader, String container, String ... expectedElementNames) throws XMLStreamException {
        boolean found = false;
        do {
            XmlReaderTools.skipUntilEvent(xmlreader, 1, 2);
            int currentEvent = xmlreader.getEventType();
            if (currentEvent == 2 && xmlreader.getLocalName().equals(container)) {
                return false;
            }
            found = XmlReaderTools.isExpected(xmlreader, expectedElementNames);
            if (found) continue;
            log.trace("Skipping over '" + xmlreader.getLocalName() + "'");
            xmlreader.next();
        } while (!found);
        return true;
    }

    public static void skipUntilEvent(XMLStreamReader xmlreader, int ... expectedEvents) throws XMLStreamException {
        int eventType = xmlreader.getEventType();
        while (!XmlReaderTools.isAnExpectedEventType(xmlreader, eventType, expectedEvents)) {
            eventType = xmlreader.next();
        }
    }
}

