/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io;

import com.calpano.kgif.io.KgifMeta;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KgifVersionTool {
    private static final Logger log = LoggerFactory.getLogger(KgifVersionTool.class);
    private static final KgifMeta KgifMeta1_0_0 = new KgifMeta("1.0.0", "2014-12-31");
    private static final KgifMeta KgifMeta1_0_1 = new KgifMeta("1.0.1", "2015-03-06");
    private static final KgifMeta KgifMeta1_1_0 = new KgifMeta("1.1.0", "2015-04-16");

    public static KgifMeta detectFromDoctype(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader, 1024);
        int lineNo = 0;
        String line = br.readLine();
        if (line == null) {
            log.warn("Reader was empty, could not find any data");
            return null;
        }
        while (line != null) {
            if ((line = line.trim()).contains("<!DOCTYPE kgif")) {
                log.trace("Found a kgif-doctype");
                if (line.contains("http://xam.de/ns/kgif/v1.0.0/kgif_v1_0_0.dtd")) {
                    return KgifMeta1_0_0;
                }
                if (line.contains("http://xam.de/ns/kgif/v1.0.0/kgif_v1_0_1.dtd") || line.contains("http://xam.de/ns/kgif/v1.0.1/kgif_v1_0_1.xsd")) {
                    return KgifMeta1_0_1;
                }
                if (line.contains("http://xam.de/ns/kgif/v1.1.0/kgif_v1_1_0.xsd")) {
                    return KgifMeta1_1_0;
                }
                log.warn("Found a kgif doctype, but could not recognize it: '" + line + "'");
            }
            if (line.startsWith("<graph>")) {
                return null;
            }
            line = br.readLine();
            if (++lineNo <= 20) continue;
            return null;
        }
        return null;
    }
}

