/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.snapshot;

import java.util.Iterator;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XRevWritableField;
import org.xydra.base.rmof.XRevWritableModel;
import org.xydra.base.rmof.XRevWritableObject;
import org.xydra.base.rmof.impl.memory.SimpleModel;
import org.xydra.store.impl.gae.snapshot.IGaeSnapshotService;

public abstract class AbstractGaeSnapshotServiceImpl
implements IGaeSnapshotService {
    @Override
    public XRevWritableField getFieldSnapshot(long modelRevisionNumber, boolean precise, XId objectId, XId fieldId) {
        XRevWritableObject objectSnapshot = this.getObjectSnapshot(modelRevisionNumber, precise, objectId);
        if (objectSnapshot == null) {
            return null;
        }
        return objectSnapshot.getField(fieldId);
    }

    @Override
    public XRevWritableObject getObjectSnapshot(long modelRevisionNumber, boolean precise, XId objectId) {
        XRevWritableModel modelSnapshot = this.getModelSnapshot(modelRevisionNumber, precise);
        if (modelSnapshot == null) {
            return null;
        }
        return modelSnapshot.getObject(objectId);
    }

    @Override
    public XRevWritableModel getPartialSnapshot(long snapshotRev, Iterable<XAddress> locks) {
        Iterator<XAddress> it = locks.iterator();
        if (!it.hasNext()) {
            return null;
        }
        if (it.next().equals(this.getModelAddress())) {
            assert (!it.hasNext());
            return this.getModelSnapshot(snapshotRev, true);
        }
        SimpleModel model = new SimpleModel(this.getModelAddress());
        block4: for (XAddress lock : locks) {
            switch (lock.getAddressedType()) {
                case XFIELD: {
                    XRevWritableField field = this.getFieldSnapshot(snapshotRev, true, lock.getObject(), lock.getField());
                    XRevWritableObject object = model.getObject(lock.getObject());
                    if (field != null) {
                        if (object == null) {
                            object = model.createObject(lock.getObject());
                            object.setRevisionNumber(-20L);
                        }
                        if (object.hasField(lock.getField())) continue block4;
                        object.addField(field);
                        break;
                    }
                    if (object != null) break;
                }
                case XOBJECT: {
                    assert (!model.hasObject(lock.getObject()));
                    XRevWritableObject object = this.getObjectSnapshot(snapshotRev, true, lock.getObject());
                    if (object == null) continue block4;
                    model.addObject(object);
                    break;
                }
                default: {
                    assert (false) : "invalid lock: " + locks;
                    continue block4;
                }
            }
        }
        return model;
    }
}

