/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import org.xydra.base.XAddress;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.UniCache;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.store.impl.gae.ng.Algorithms;
import org.xydra.store.impl.gae.ng.GaeModelRevInfo;
import org.xydra.store.impl.gae.ng.UniCacheRevisionInfoEntryHandler;

public class RevisionManager {
    private static final Logger log = LoggerFactory.getLogger(RevisionManager.class);
    public static final long WRITE_REV_EVERY = 16L;
    private final XAddress modelAddress;
    private GaeModelRevInfo revision;
    private final UniCache<GaeModelRevInfo> uniRevCache;

    public RevisionManager(XAddress modelAddress) {
        this.modelAddress = modelAddress;
        this.revision = null;
        this.uniRevCache = new UniCache<GaeModelRevInfo>(UniCacheRevisionInfoEntryHandler.instance(), "CACHEDREV");
    }

    public void foundNewHigherCommitedChange(GaeChange change) {
        XyAssert.xyAssert((!change.getStatus().canChange() ? 1 : 0) != 0);
        if (change.getStatus().changedSomething()) {
            if (this.revision.getLastStableCommitted() + 1L == change.rev) {
                boolean modelExists = Algorithms.changeIndicatesModelExists(change);
                this.revision.incrementLastStableSuccessChange(change.rev, modelExists, System.currentTimeMillis());
                this.revision.setPrecisionToImprecise();
                this.writeToDatastoreAndMemcache();
            } else {
                this.revision.incrementLastSuccessChange(change.rev);
                this.revision.setPrecisionToImprecise();
            }
        } else if (this.revision.getLastStableCommitted() + 1L == change.rev) {
            this.revision.incrementLastStableCommitted(change.rev);
            this.revision.setPrecisionToImprecise();
            this.writeToDatastoreAndMemcache();
        } else {
            this.revision.incrementLastTaken(change.rev);
        }
    }

    public void foundNewLastTaken(long rev) {
        this.revision.incrementLastTaken(rev);
    }

    public GaeModelRevInfo getInfo() {
        if (this.revision == null) {
            this.readFromDatastoreAndMemcache();
        }
        if (this.revision == null) {
            this.revision = GaeModelRevInfo.createModelDoesNotExist();
        }
        XyAssert.xyAssert((this.revision != null ? 1 : 0) != 0);
        return this.revision;
    }

    public void readFromDatastoreAndMemcache() {
        boolean memcache = true;
        boolean datastore = true;
        GaeModelRevInfo value = this.uniRevCache.get("" + this.modelAddress, UniCache.StorageOptions.create(0, true, true, false));
        if (value != null) {
            if (this.revision == null) {
                log.debug("Got rev " + value + " from unicache => using it");
                this.revision = value;
            } else {
                log.debug("Got rev " + value + " from unicache -> updating from " + this.revision);
                this.revision.incrementFrom(value);
            }
            value.setPrecision(GaeModelRevInfo.Precision.Loaded);
        }
    }

    public void writeToDatastoreAndMemcache() {
        if (this.revision == null) {
            this.readFromDatastoreAndMemcache();
        }
        boolean memcache = true;
        boolean datastore = this.revision.getLastStableSuccessChange() % 16L == 0L;
        this.uniRevCache.put("" + this.modelAddress, this.revision, UniCache.StorageOptions.create(0, true, datastore, false));
    }
}

