/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import java.io.Serializable;
import org.xydra.sharedutils.XyAssert;

public class GaeModelRevInfo
implements Serializable {
    private static final long serialVersionUID = -6269753819062518229L;
    private long lastStableCommitted = -1L;
    private long lastStableSuccess = -1L;
    private long lastSuccess = -1L;
    private long lastTaken = -1L;
    private boolean modelExists = false;
    private long timestamp = -1L;
    private transient String debugHint = "na";
    private Precision precision = Precision.None;

    public static GaeModelRevInfo createModelDoesNotExist() {
        return new GaeModelRevInfo(System.currentTimeMillis(), false, -1L, -1L, -1L, -1L, Precision.None);
    }

    public static long getSerialversionuid() {
        return -6269753819062518229L;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    GaeModelRevInfo() {
    }

    public GaeModelRevInfo(long timestamp, boolean modelExists, long lastStableSuccess, long lastStableCommitted, long lastSuccess, long lastTaken, Precision precision) {
        this.timestamp = timestamp;
        XyAssert.xyAssert((-1L <= lastStableSuccess ? 1 : 0) != 0);
        XyAssert.xyAssert((lastStableSuccess <= lastStableCommitted ? 1 : 0) != 0);
        XyAssert.xyAssert((lastStableCommitted <= lastTaken ? 1 : 0) != 0);
        XyAssert.xyAssert((lastStableSuccess <= lastSuccess ? 1 : 0) != 0, (String)"lastStableSuccess=%s <= lastSuccess=%s", (Object[])new Object[]{lastStableSuccess, lastSuccess});
        XyAssert.xyAssert((lastSuccess <= lastTaken ? 1 : 0) != 0);
        this.modelExists = modelExists;
        this.timestamp = timestamp;
        this.lastStableSuccess = lastStableSuccess;
        this.lastStableCommitted = lastStableCommitted;
        this.lastSuccess = lastSuccess;
        this.lastTaken = lastTaken;
        this.precision = precision;
    }

    public long getLastStableCommitted() {
        return this.lastStableCommitted;
    }

    public long getLastStableSuccessChange() {
        return this.lastStableSuccess;
    }

    public long getLastSuccessChange() {
        return this.lastSuccess;
    }

    public long getLastTaken() {
        return this.lastTaken;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void incrementFrom(GaeModelRevInfo other) {
        this.incrementLastStableSuccessChange(other.lastStableSuccess, other.modelExists, other.timestamp);
        this.incrementLastStableCommitted(other.lastStableCommitted);
        this.incrementLastSuccessChange(other.lastSuccess);
        this.incrementLastTaken(other.lastTaken);
    }

    public void incrementLastStableCommitted(long lastStableCommitted) {
        if (lastStableCommitted > this.lastStableCommitted) {
            this.lastStableCommitted = lastStableCommitted;
        }
        this.incrementLastTaken(lastStableCommitted);
    }

    public void incrementLastStableSuccessChange(long lastStableSuccess, boolean modelExists, long timestamp) {
        boolean changes = this.incrementLastStableSuccessChange_internal(lastStableSuccess);
        if (changes) {
            this.modelExists = modelExists;
            this.timestamp = timestamp;
        }
    }

    private boolean incrementLastStableSuccessChange_internal(long lastStableSuccess) {
        boolean changedStableSuccess = false;
        if (lastStableSuccess > this.lastStableSuccess) {
            this.lastStableSuccess = lastStableSuccess;
            changedStableSuccess = true;
        }
        this.incrementLastStableCommitted(lastStableSuccess);
        this.incrementLastSuccessChange(lastStableSuccess);
        return changedStableSuccess;
    }

    public void incrementLastSuccessChange(long lastSuccess) {
        if (lastSuccess > this.lastSuccess) {
            this.lastSuccess = lastSuccess;
        }
        this.incrementLastTaken(lastSuccess);
    }

    public boolean incrementLastTaken(long lastTaken) {
        if (lastTaken > this.lastTaken) {
            this.lastTaken = lastTaken;
            return true;
        }
        return false;
    }

    public boolean isModelExists() {
        return this.modelExists;
    }

    public void setModelExists(boolean modelExists) {
        this.modelExists = modelExists;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return XyAssert.format((String)"(prec: %s),stable(succ: %s <= comm %s) <= unstable(succ %s <= taken %s) modelExists?%s at %s. \n  (SOURCE='%s')", (Object[])new Object[]{this.precision, this.lastStableSuccess, this.lastStableCommitted, this.lastSuccess, this.lastTaken, this.modelExists, this.timestamp, this.debugHint});
    }

    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    public GaeModelRevInfo copy() {
        return new GaeModelRevInfo(this.timestamp, this.modelExists, this.lastStableSuccess, this.lastStableCommitted, this.lastSuccess, this.lastTaken, this.precision);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GaeModelRevInfo)) {
            return false;
        }
        GaeModelRevInfo o = (GaeModelRevInfo)other;
        return this.modelExists == o.modelExists && this.timestamp == o.timestamp && this.precision == o.precision && this.lastStableCommitted == o.lastStableCommitted && this.lastStableSuccess == o.lastStableSuccess && this.lastSuccess == o.lastSuccess && this.lastTaken == o.lastTaken;
    }

    public int hashCode() {
        return (int)this.timestamp + (int)this.lastStableSuccess + this.precision.hashCode() + (this.modelExists ? 0 : 1);
    }

    public void setPrecisionToImprecise() {
        if (this.precision == Precision.Precise) {
            this.precision = Precision.Imprecise;
        }
    }

    public void setDebugHint(String debugHint) {
        this.debugHint = debugHint;
    }

    public static enum Precision {
        None,
        Loaded,
        Precise,
        Imprecise;

    }
}

