/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.xydra.annotations.Setting;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.change.XAtomicEvent;
import org.xydra.base.change.XCommand;
import org.xydra.base.change.XEvent;
import org.xydra.base.change.XFieldEvent;
import org.xydra.base.change.XTransactionEvent;
import org.xydra.base.rmof.XReadableField;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XRevWritableField;
import org.xydra.base.rmof.XRevWritableModel;
import org.xydra.base.rmof.XStateWritableField;
import org.xydra.base.rmof.XStateWritableObject;
import org.xydra.base.rmof.XWritableModel;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.rmof.impl.XExistsRevWritableObject;
import org.xydra.common.NanoClock;
import org.xydra.core.XCopyUtils;
import org.xydra.core.model.delta.ChangedField;
import org.xydra.core.model.delta.ChangedObject;
import org.xydra.index.iterator.AbstractFilteringIterator;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.persistence.ModelRevision;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.IGaeModelPersistence;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.store.impl.gae.changes.GaeLocks;
import org.xydra.store.impl.gae.changes.VoluntaryTimeoutException;
import org.xydra.store.impl.gae.ng.Algorithms;
import org.xydra.store.impl.gae.ng.ChangeLogManager;
import org.xydra.store.impl.gae.ng.CheckResult;
import org.xydra.store.impl.gae.ng.ContextBeforeCommand;
import org.xydra.store.impl.gae.ng.ContextInTxn;
import org.xydra.store.impl.gae.ng.ExecutionResult;
import org.xydra.store.impl.gae.ng.Executor;
import org.xydra.store.impl.gae.ng.GaeModelRevInfo;
import org.xydra.store.impl.gae.ng.GaeSnapshotServiceImpl5;
import org.xydra.store.impl.gae.ng.Interval;
import org.xydra.store.impl.gae.ng.RevisionManager;
import org.xydra.store.impl.gae.ng.TentativeObjectState;
import org.xydra.store.impl.gae.snapshot.IGaeSnapshotService;
import org.xydra.store.impl.utils.DebugFormatter;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.util.FutureUtils;

public class GaeModelPersistenceNG
implements IGaeModelPersistence {
    static final Logger log = LoggerFactory.getLogger(GaeModelPersistenceNG.class);
    @Setting(value="")
    private static final long MAX_CHANGES_FETCH_SIZE = 19L;
    @Setting(value="")
    private static final long WAIT_INITIAL = 10L;
    @Setting(value="")
    private static final long WAIT_MAX = 1000L;
    private final ChangeLogManager changelogManager;
    private final XAddress modelAddress;
    private final RevisionManager revisionManager;
    private final IGaeSnapshotService snapshotService;
    private final ContextBeforeCommand executionContext;

    public GaeModelPersistenceNG(XAddress modelAddress) {
        this.modelAddress = modelAddress;
        this.revisionManager = new RevisionManager(this.modelAddress);
        GaeModelRevInfo info = this.revisionManager.getInfo();
        this.changelogManager = new ChangeLogManager(this.modelAddress);
        this.snapshotService = new GaeSnapshotServiceImpl5(this.changelogManager);
        this.executionContext = new ContextBeforeCommand(modelAddress, info, this.snapshotService);
        XyAssert.xyAssert((this.executionContext.getAddress() != null ? 1 : 0) != 0);
    }

    public boolean equals(Object other) {
        return other instanceof GaeModelPersistenceNG && ((GaeModelPersistenceNG)other).modelAddress.equals(this.modelAddress);
    }

    private void execute_saveEventsReleaseLocks(ExecutionResult executionResult, GaeChange change) throws VoluntaryTimeoutException {
        if (executionResult.getStatus().isFailure()) {
            change.giveUpIfTimeoutCritical();
            this.changelogManager.commitAndClearLocks(change, GaeChange.Status.FailedPreconditions);
            return;
        }
        XyAssert.xyAssert((boolean)executionResult.getStatus().isSuccess());
        List<XAtomicEvent> events = executionResult.getEvents();
        long atomicEventCount = events.size();
        log.debug("[r" + change.rev + "] generated " + events.size() + " events");
        if (events.isEmpty()) {
            change.giveUpIfTimeoutCritical();
            this.changelogManager.commitAndClearLocks(change, GaeChange.Status.SuccessNochange);
            log.debug("No change");
            return;
        }
        XyAssert.xyAssert((!events.isEmpty() ? 1 : 0) != 0);
        if (atomicEventCount > 1000L) {
            log.warn("Created over 1000 events (" + atomicEventCount + ") GA?category=xydra&action=saveManyEvents&label=events&value=" + atomicEventCount);
            try {
                throw new RuntimeException("Over 1000 events for result=" + executionResult + " change=" + change);
            }
            catch (Exception e) {
                log.warn("Over 1000 events", (Throwable)e);
            }
        }
        Pair<int[], List<Future<SKey>>> res = change.setEvents(events);
        for (Future future : (List)res.getSecond()) {
            FutureUtils.waitFor((Future)future);
        }
        change.giveUpIfTimeoutCritical();
        this.changelogManager.commitAndClearLocks(change, GaeChange.Status.SuccessExecutedApplied);
    }

    private void execute_waitForLocks(GaeChange ourChange, GaeModelRevInfo info, RevisionManager revisionManager) throws VoluntaryTimeoutException {
        long lastCommited = info.getLastStableCommitted();
        XyAssert.xyAssert((lastCommited == -1L || ourChange.rev > lastCommited ? 1 : 0) != 0, (Object)"If a lastSilentCommitted is not undefiend (i.e. == -1), it must be before this change");
        Interval pendingChangesSearchRange = new Interval(lastCommited + 1L, ourChange.rev - 1L);
        if (pendingChangesSearchRange.isEmpty()) {
            return;
        }
        XyAssert.xyAssert((pendingChangesSearchRange.size() < 1000L ? 1 : 0) != 0, (String)"?", (Object[])new Object[]{pendingChangesSearchRange, pendingChangesSearchRange.size()});
        Interval fetchRange = pendingChangesSearchRange.copy();
        fetchRange.adjustStartToFitSizeIfNecessary(19L);
        Map<Long, GaeChange> changes = this.changelogManager.getChanges(fetchRange);
        for (long rev = fetchRange.start; rev <= fetchRange.end; ++rev) {
            GaeChange otherChange = changes.get(rev);
            XyAssert.xyAssert((otherChange != null ? 1 : 0) != 0);
            assert (otherChange != null);
            if (this.changelogManager.progressChangeIfTimedOut(otherChange, revisionManager)) continue;
            if (!otherChange.getStatus().canChange()) {
                this.revisionManager.foundNewHigherCommitedChange(otherChange);
                continue;
            }
            GaeLocks nextLocks = otherChange.getLocks();
            if (!nextLocks.isConflicting(ourChange.getLocks())) continue;
            this.execute_waitForOtherThreadToCommit(ourChange, otherChange);
        }
    }

    private void execute_waitForOtherThreadToCommit(GaeChange ourChange, GaeChange nextChange) throws VoluntaryTimeoutException {
        long waitTime = 10L;
        while (!nextChange.isTimedOut()) {
            ourChange.giveUpIfTimeoutCritical();
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            nextChange.reload();
            if (!nextChange.getStatus().canChange()) {
                XyAssert.xyAssert((!nextChange.hasLocks() ? 1 : 0) != 0, (Object)"now finished, so cannot have no locks anymore");
                this.revisionManager.foundNewHigherCommitedChange(nextChange);
                return;
            }
            waitTime = Algorithms.increaseExponentiallyWithFactorAndMaximum(waitTime, 2, 1000L);
        }
        XyAssert.xyAssert((boolean)nextChange.isTimedOut(), (Object)"nextChange timed out");
        this.changelogManager.commitAndClearLocks(nextChange, GaeChange.Status.FailedTimeout);
    }

    @Override
    public long executeCommand(XCommand command, XId actorId) throws VoluntaryTimeoutException {
        CheckResult checkResult;
        log.debug("----------------------------------------- Execute " + DebugFormatter.format((Object)command));
        NanoClock c = new NanoClock().start();
        XyAssert.xyAssert((boolean)this.modelAddress.equalsOrContains(command.getChangedEntity()), (Object)("cannot handle command " + command + " - it does not address a model"));
        GaeLocks locks = GaeLocks.createLocks(command);
        c.stopAndStart("createlocks");
        XyAssert.xyAssert((locks.size() > 0 ? 1 : 0) != 0, (String)"no locks created for command %s", (Object[])new Object[]{command});
        log.debug("[???] Phase 1: grabRevisionAndRegister " + locks.size() + " locks = " + locks);
        GaeModelRevInfo info = this.revisionManager.getInfo();
        GaeChange change = this.grabRevisionAndRegisterLocks(info, locks, actorId);
        XyAssert.xyAssert((change.rev >= 0L ? 1 : 0) != 0);
        c.stopAndStart("grabRevisionAndRegisterLocks");
        log.debug("[r" + change.rev + "] Phase 2: waitForLocks");
        this.execute_waitForLocks(change, info, this.revisionManager);
        c.stopAndStart("waitForLocks");
        log.debug("[r" + change.rev + "] Phase 3: check constraints, compute events = " + change + ", command = " + command);
        try {
            checkResult = Executor.checkPreconditions(this.executionContext, command, change);
        }
        catch (Throwable t) {
            log.error("Error in phase 3", t);
            throw new RuntimeException(t);
        }
        log.debug("[r" + change.rev + "] Phase 3b: computeEvents '" + checkResult.getStatus().name() + "' change = " + change + ", command = " + command);
        ExecutionResult executionResult = ExecutionResult.createEventsFrom(checkResult, this.executionContext);
        log.debug("[r" + change.rev + "] Phase 3c: updateTos '" + executionResult.getStatus().name() + "' change = " + change + ", command = " + command + " --> " + executionResult.getEvents().size() + " events");
        if (checkResult.getStatus() == GaeChange.Status.SuccessExecuted) {
            GaeModelPersistenceNG.updateTentativeObjectStates(checkResult.getExecutionContextInTxn(), this.executionContext, change.rev);
        }
        log.debug("[r" + change.rev + "] Phase 4: saveEvents '" + executionResult.getStatus().name() + "' change = " + change + ", command = " + command);
        this.execute_saveEventsReleaseLocks(executionResult, change);
        c.stopAndStart("saveEvents");
        XyAssert.xyAssert((!change.getStatus().canChange() ? 1 : 0) != 0, (Object)"If we reach this line, change must be committed");
        this.revisionManager.foundNewHigherCommitedChange(change);
        if (log.isInfoEnabled() || executionResult.getStatus().isFailure() && log.isWarnEnabled()) {
            String msg = "[r" + change.rev + "] -> " + (Object)((Object)executionResult.getStatus()) + "." + (executionResult.getDebugHint() != null ? " Reason: " + executionResult.getDebugHint() : "") + " Stats: " + c.getStats();
            if (executionResult.getStatus().isFailure()) {
                log.warn("!!! " + msg);
            } else {
                log.debug("+++ " + msg);
            }
        }
        log.debug("Resulting revInfo: " + this.revisionManager.getInfo() + " for " + this.modelAddress);
        switch (executionResult.getStatus()) {
            case FailedPreconditions: {
                return -1L;
            }
            case FailedTimeout: {
                return -1L;
            }
            case SuccessExecuted: 
            case SuccessExecutedApplied: {
                return change.rev;
            }
            case SuccessNochange: {
                return -2L;
            }
        }
        throw new AssertionError((Object)"Cannot happen");
    }

    private static void updateTentativeObjectStates(ContextInTxn sourceContext, ContextBeforeCommand targetContext, long changeRev) {
        TentativeObjectState tos;
        for (XReadableObject xReadableObject : sourceContext.getAdded()) {
            tos = new TentativeObjectState(xReadableObject, true, changeRev);
            Iterator<Object> i$ = tos.iterator();
            while (i$.hasNext()) {
                XId fieldId = i$.next();
                XRevWritableField field = tos.getField(fieldId);
                field.setRevisionNumber(changeRev);
            }
            tos.setRevisionNumber(changeRev);
            targetContext.saveTentativeObjectState(tos);
        }
        for (XId xId : sourceContext.getRemoved()) {
            tos = targetContext.getTentativeObjectState(xId);
            XyAssert.xyAssert((tos != null ? 1 : 0) != 0);
            assert (tos != null);
            tos.setObjectExists(false);
            tos.setModelRev(changeRev);
            tos.setRevisionNumber(changeRev);
            targetContext.saveTentativeObjectState(tos);
        }
        for (ChangedObject changedObject : sourceContext.getChanged()) {
            if (!changedObject.hasChanges()) continue;
            XExistsRevWritableObject object = XCopyUtils.createSnapshot((XReadableObject)changedObject);
            for (XReadableField addedField : changedObject.getAdded()) {
                object.getField(addedField.getId()).setRevisionNumber(changeRev);
            }
            for (ChangedField changedField : changedObject.getChangedFields()) {
                if (!changedField.isChanged()) continue;
                object.getField(changedField.getId()).setRevisionNumber(changeRev);
            }
            TentativeObjectState tos2 = new TentativeObjectState((XReadableObject)object, true, changeRev);
            tos2.setRevisionNumber(changeRev);
            targetContext.saveTentativeObjectState(tos2);
        }
    }

    @Override
    public List<XEvent> getEventsBetween(final XAddress address, long beginRevision, long endRevision) {
        Interval interval = new Interval(beginRevision, endRevision);
        List<XEvent> events = this.changelogManager.getEventsInInterval(interval);
        if (address.getAddressedType() == XType.XMODEL) {
            XyAssert.xyAssert((boolean)address.equals(this.modelAddress));
            if (events.size() == 0) {
                return null;
            }
            return events;
        }
        XyAssert.xyAssert((boolean)Base.resolveModel((XAddress)address).equals(this.modelAddress), (String)"", (Object[])new Object[]{address, this.modelAddress});
        AbstractFilteringIterator<XEvent> it = new AbstractFilteringIterator<XEvent>(events.iterator()){

            protected boolean matchesFilter(XEvent entry) {
                if (entry instanceof XTransactionEvent) {
                    XTransactionEvent txnEvent = (XTransactionEvent)entry;
                    for (XAtomicEvent a : txnEvent) {
                        if (!GaeModelPersistenceNG.addressContainsOther(address, a.getChangedEntity())) continue;
                        return true;
                    }
                    return false;
                }
                return GaeModelPersistenceNG.addressContainsOther(address, entry.getChangedEntity());
            }
        };
        return (List)Iterators.addAll((Iterator)it, new LinkedList());
    }

    public static boolean addressContainsOther(XAddress a, XAddress b) {
        switch (a.getAddressedType()) {
            case XREPOSITORY: {
                return b.getRepository().equals((Object)a.getRepository());
            }
            case XMODEL: {
                return b.getRepository().equals((Object)a.getRepository()) && b.getModel() != null && b.getModel().equals((Object)a.getModel());
            }
            case XOBJECT: {
                return b.getRepository().equals((Object)a.getRepository()) && b.getModel() != null && b.getModel().equals((Object)a.getModel()) && b.getObject() != null && b.getObject().equals((Object)a.getObject());
            }
            case XFIELD: {
                return a.equals(b);
            }
        }
        throw new AssertionError();
    }

    @Override
    public ModelRevision getModelRevision(boolean includeTentative) {
        ModelRevision modelRev;
        this.computeMorePreciseCurrentRev();
        GaeModelRevInfo info = this.revisionManager.getInfo();
        long revision = info.getLastStableSuccessChange();
        boolean modelExists = info.isModelExists();
        if (includeTentative) {
            long tentativeRevision = info.getLastSuccessChange();
            modelRev = new ModelRevision(revision, modelExists, tentativeRevision);
        } else {
            modelRev = new ModelRevision(revision, modelExists);
        }
        return modelRev;
    }

    private void computeMorePreciseCurrentRev() {
        GaeModelRevInfo info = this.revisionManager.getInfo();
        long lastCommited = info.getLastStableCommitted();
        long searchStart = Math.max(lastCommited, 0L);
        Interval currentSearchRange = new Interval(searchStart, searchStart + 19L);
        log.debug("@" + this.modelAddress + " compute rev from " + info + " in " + currentSearchRange);
        this.computeMorePreciseCurrentRevInInterval(info, currentSearchRange);
        log.debug("@" + this.modelAddress + " new rev is " + info + "; searched " + currentSearchRange);
    }

    private void computeMorePreciseCurrentRevInInterval(GaeModelRevInfo info, Interval searchRange) {
        XyAssert.xyAssert((searchRange.start >= 0L ? 1 : 0) != 0);
        Interval window = searchRange.copy();
        while (true) {
            Map<Long, GaeChange> changes;
            if ((changes = this.changelogManager.getChanges(window)).isEmpty()) {
                log.debug("Found no changes in " + window);
                info.setPrecision(GaeModelRevInfo.Precision.Precise);
                info.setDebugHint("Found no changes in " + window + " so rev " + info.getLastStableSuccessChange() + " is now precise for " + this.modelAddress);
                return;
            }
            for (long rev = window.start; rev <= window.end; ++rev) {
                GaeChange change = changes.get(rev);
                if (change == null) {
                    log.debug("Found first empty spot in changelog at rev=" + rev);
                    info.setDebugHint("Found first empty spot in changelog at rev=" + rev);
                    info.setPrecision(GaeModelRevInfo.Precision.Precise);
                    return;
                }
                boolean progressed = this.changelogManager.progressChangeIfTimedOut(change, this.revisionManager);
                if (progressed) continue;
                if (!change.getStatus().canChange()) {
                    this.revisionManager.foundNewHigherCommitedChange(change);
                    continue;
                }
                log.debug("Found first pending spot in changelog at rev=" + rev + " status=" + (Object)((Object)change.getStatus()));
                info.setPrecision(GaeModelRevInfo.Precision.Precise);
                info.setDebugHint("Found first pending spot in changelog at rev=" + rev + " status=" + (Object)((Object)change.getStatus()));
                return;
            }
            window = window.moveRight();
        }
    }

    @Override
    public XWritableObject getObjectSnapshot(XId objectId, boolean includeTentative) {
        if (includeTentative) {
            TentativeObjectState tos = this.executionContext.getObject(objectId);
            if (tos == null) {
                return null;
            }
            if (!tos.exists()) {
                return null;
            }
            return tos;
        }
        XWritableModel snapshot = this.getSnapshot(includeTentative);
        if (snapshot == null) {
            return null;
        }
        return snapshot.getObject(objectId);
    }

    @Override
    public synchronized XWritableModel getSnapshot(boolean includeTentative) {
        this.computeMorePreciseCurrentRev();
        GaeModelRevInfo info = this.revisionManager.getInfo();
        XyAssert.xyAssert((info.getPrecision() == GaeModelRevInfo.Precision.Precise ? 1 : 0) != 0);
        if (!info.isModelExists()) {
            return null;
        }
        long currentRevNr = info.getLastStableSuccessChange();
        if (includeTentative) {
            XWritableModel snapshot = this.snapshotService.getTentativeModelSnapshot(currentRevNr);
            log.info("return tentative snapshot rev " + currentRevNr + " for model " + this.modelAddress);
            return snapshot;
        }
        XRevWritableModel snapshot = this.snapshotService.getModelSnapshot(currentRevNr, !includeTentative);
        log.debug("return snapshot rev " + currentRevNr + " for model " + this.modelAddress);
        return snapshot;
    }

    private GaeChange grabRevisionAndRegisterLocks(GaeModelRevInfo info, GaeLocks locks, XId actorId) {
        long lastTaken = info.getLastTaken();
        XyAssert.xyAssert((lastTaken >= -1L ? 1 : 0) != 0);
        long start = lastTaken + 1L;
        GaeChange change = this.changelogManager.grabRevisionAndRegisterLocks(locks, actorId, start, this.revisionManager);
        return change;
    }

    public int hashCode() {
        return this.modelAddress.hashCode();
    }

    @Override
    public boolean modelHasBeenManaged() {
        GaeChange change = this.changelogManager.getChange(0L);
        return change != null;
    }

    public static void rollForward_updateTentativeObjectStates(XAddress modelAddress, GaeChange change, GaeModelRevInfo info, ChangeLogManager changelogManager) {
        XyAssert.xyAssert((boolean)change.getStatus().changedSomething());
        log.debug("roll forward " + change);
        GaeSnapshotServiceImpl5 snapshotService = new GaeSnapshotServiceImpl5(changelogManager);
        ContextBeforeCommand ctxBeforeCmd = new ContextBeforeCommand(modelAddress, info, snapshotService);
        ContextInTxn ctxInTxn = ctxBeforeCmd.forkTxn();
        XEvent event = change.getEvent();
        if (event instanceof XTransactionEvent) {
            XTransactionEvent txnEvent = (XTransactionEvent)event;
            for (int i = 0; i < txnEvent.size(); ++i) {
                XAtomicEvent e = txnEvent.getEvent(i);
                GaeModelPersistenceNG.updateTentativeObjectStates(modelAddress, e, ctxInTxn);
            }
        } else {
            XAtomicEvent e = (XAtomicEvent)event;
            GaeModelPersistenceNG.updateTentativeObjectStates(modelAddress, e, ctxInTxn);
        }
        GaeModelPersistenceNG.updateTentativeObjectStates(ctxInTxn, ctxBeforeCmd, change.rev);
        change.setStatus(GaeChange.Status.SuccessExecutedApplied);
        change.save();
    }

    private static void updateTentativeObjectStates(XAddress modelAddress, XAtomicEvent e, ContextInTxn ctxInTxn) {
        block0 : switch (e.getTarget().getAddressedType()) {
            case XREPOSITORY: {
                switch (e.getChangeType()) {
                    case ADD: {
                        ctxInTxn.setExists(true);
                        break block0;
                    }
                    case REMOVE: {
                        ctxInTxn.setExists(false);
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case XMODEL: {
                switch (e.getChangeType()) {
                    case ADD: {
                        ctxInTxn.createObject(e.getChangedEntity().getObject());
                        break block0;
                    }
                    case REMOVE: {
                        ctxInTxn.removeObject(e.getChangedEntity().getObject());
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case XOBJECT: {
                XStateWritableObject obj = ctxInTxn.getObject(e.getChangedEntity().getObject());
                switch (e.getChangeType()) {
                    case ADD: {
                        obj.createField(e.getChangedEntity().getField());
                        break block0;
                    }
                    case REMOVE: {
                        obj.removeField(e.getChangedEntity().getField());
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case XFIELD: {
                XStateWritableObject obj = ctxInTxn.getObject(e.getChangedEntity().getObject());
                XStateWritableField field = obj.getField(e.getChangedEntity().getField());
                XFieldEvent fieldEvent = (XFieldEvent)e;
                switch (e.getChangeType()) {
                    case ADD: {
                        field.setValue(fieldEvent.getNewValue());
                        break block0;
                    }
                    case REMOVE: {
                        field.setValue(null);
                        break block0;
                    }
                    case CHANGE: {
                        field.setValue(fieldEvent.getNewValue());
                        break block0;
                    }
                }
                throw new AssertionError();
            }
        }
    }
}

