/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.execute;

import java.util.concurrent.Future;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.rmof.XReadableField;
import org.xydra.base.value.XValue;
import org.xydra.store.impl.gae.changes.GaeEvents;
import org.xydra.store.impl.gae.changes.GaeLocks;
import org.xydra.store.impl.gae.changes.IGaeChangesService;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.store.impl.gae.execute.InternalGaeXEntity;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;

class InternalGaeField
extends InternalGaeXEntity
implements XReadableField {
    private static final String PROP_TRANSINDEX = "transindex";
    private final IGaeChangesService gcs;
    private final XAddress fieldAddr;
    private final long fieldRev;
    private final int transindex;
    private GaeEvents.AsyncValue value;

    protected InternalGaeField(IGaeChangesService gcs, XAddress fieldAddr, SEntity fieldEntity) {
        this.gcs = gcs;
        assert (fieldAddr.getAddressedType() == XType.XFIELD);
        this.fieldAddr = fieldAddr;
        this.fieldRev = InternalGaeField.getFieldRev(fieldEntity);
        this.transindex = InternalGaeField.getTransIndex(fieldEntity);
    }

    public long getRevisionNumber() {
        return this.fieldRev;
    }

    public XValue getValue() {
        if (this.value == null) {
            this.value = this.gcs.getValue(this.fieldRev, this.transindex);
        }
        return this.value.get();
    }

    public boolean isEmpty() {
        return this.transindex == -1;
    }

    public XAddress getAddress() {
        return this.fieldAddr;
    }

    public XId getId() {
        return this.fieldAddr.getField();
    }

    protected static Future<SKey> set(XAddress fieldAddr, long fieldRev, int transindex, GaeLocks locks) {
        assert (locks.canWrite(fieldAddr));
        assert (fieldAddr.getAddressedType() == XType.XFIELD);
        SEntity e = XGae.get().datastore().createEntity(KeyStructure.createEntityKey(fieldAddr));
        e.setAttribute("revision", fieldRev);
        e.setAttribute(PROP_TRANSINDEX, (long)transindex);
        return XGae.get().datastore().async().putEntity(e);
    }

    protected static Future<SKey> set(XAddress fieldAddr, long fieldRev, GaeLocks locks) {
        return InternalGaeField.set(fieldAddr, fieldRev, -1, locks);
    }

    private static int getTransIndex(SEntity fieldEntity) {
        Number transindex = (Number)fieldEntity.getAttribute(PROP_TRANSINDEX);
        return transindex.intValue();
    }

    private static long getFieldRev(SEntity fieldEntity) {
        long fieldRev = (Long)fieldEntity.getAttribute("revision");
        return fieldRev;
    }

    public XType getType() {
        return XType.XFIELD;
    }
}

