/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XType;
import org.xydra.base.change.XAtomicCommand;
import org.xydra.base.change.XCommand;
import org.xydra.base.change.XTransaction;
import org.xydra.index.iterator.ReadOnlyIterator;

public class GaeLocks
implements Iterable<XAddress> {
    public static final long serialVersionUID = 4334940263327007176L;
    private final Set<XAddress> locks;

    public static GaeLocks createLocks(XCommand command) {
        GaeLocks gaeLocks = new GaeLocks();
        if (command instanceof XTransaction) {
            XTransaction transaction = (XTransaction)command;
            HashSet<XAddress> tempLocks = new HashSet<XAddress>();
            for (XAtomicCommand atomicCommand : transaction) {
                XAddress lock = atomicCommand.getChangedEntity();
                assert (lock != null);
                tempLocks.add(lock);
            }
            for (XAddress lock : tempLocks) {
                if (GaeLocks.hasMoreGeneralLock(tempLocks, lock)) continue;
                gaeLocks.add(lock);
            }
        } else {
            XAddress lock = command.getChangedEntity();
            assert (lock != null);
            gaeLocks.add(lock);
        }
        return gaeLocks;
    }

    private void add(XAddress lockAddress) {
        assert (lockAddress != null);
        this.locks.add(lockAddress);
    }

    protected GaeLocks(List<String> encodedLocks) {
        this.locks = new HashSet<XAddress>((int)((double)encodedLocks.size() / 0.75));
        for (String s : encodedLocks) {
            this.locks.add(Base.toAddress((String)s));
        }
    }

    public GaeLocks() {
        this.locks = new HashSet<XAddress>();
    }

    List<String> encode() {
        ArrayList<String> lockStrs = new ArrayList<String>(this.locks.size());
        for (XAddress a : this.locks) {
            lockStrs.add(a.toURI());
        }
        return lockStrs;
    }

    public boolean canWrite(XAddress addr) {
        for (XAddress lock : this.locks) {
            if (!lock.equalsOrContains(addr)) continue;
            return true;
        }
        return false;
    }

    public boolean canRead(XAddress addr) {
        for (XAddress lock : this.locks) {
            if (!addr.equalsOrContains(lock) && !lock.contains(addr)) continue;
            return true;
        }
        return false;
    }

    public boolean isConflicting(GaeLocks other) {
        for (XAddress lock : this.locks) {
            if (!other.locks.contains(lock) && !GaeLocks.hasMoreGeneralLock(other.locks, lock)) continue;
            return true;
        }
        for (XAddress lock : other.locks) {
            if (!GaeLocks.hasMoreGeneralLock(this.locks, lock)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMoreGeneralLock(Set<XAddress> locks, XAddress lock) {
        for (XAddress l = lock.getParent(); l != null; l = l.getParent()) {
            if (!locks.contains(l)) continue;
            return true;
        }
        return false;
    }

    public boolean canRemove(XAddress addr) {
        return this.canWrite(addr);
    }

    public int size() {
        return this.locks.size();
    }

    @Override
    public Iterator<XAddress> iterator() {
        return new ReadOnlyIterator(this.locks.iterator());
    }

    public String toString() {
        return Arrays.toString(this.encode().toArray());
    }

    public boolean isLockingTheModel() {
        XAddress xa;
        return this.locks.size() == 1 && (xa = this.locks.iterator().next()).getAddressedType() == XType.XMODEL;
    }
}

